/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Unban User")
@Description(value={"Unbans a user from a guild."})
@Examples(value={"unban event-user in guild with id \"818182471140114432\""})
public class UnbanMember
extends AsyncEffect {
    private Expression<Object> exprTarget;
    private Expression<Guild> exprGuild;
    private Node node;

    public boolean init(Expression[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.exprTarget = expr[0];
        this.exprGuild = expr[1];
        this.node = this.getParser().getNode();
        return true;
    }

    public void execute(@NotNull Event e) {
        Guild guild;
        Object target = EasyElement.parseSingle(this.exprTarget, e, null);
        if (!DiSkyRuntimeHandler.checkSet(this.node, target, this.exprTarget, guild = (Guild)EasyElement.parseSingle(this.exprGuild, e, null), this.exprGuild)) {
            return;
        }
        if (!(target instanceof UserSnowflake) && !(target instanceof String)) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The given object is not a discord user or a string (user id)!"), this.node);
            return;
        }
        UserSnowflake user = target instanceof UserSnowflake ? (UserSnowflake)target : UserSnowflake.fromId(target);
        try {
            guild.unban(user).complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex, this.node);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "unban " + this.exprTarget.toString(e, debug) + " from guild " + this.exprGuild.toString(e, debug);
    }

    static {
        Skript.registerEffect(UnbanMember.class, (String[])new String[]{"[discord] un[-| ]ban [the] [discord] [user] %user/string% (from|in) [guild] %guild%"});
    }
}

