/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.find;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindMembersWithRoles
extends AsyncEffect {
    private Expression<Role> exprRoles;
    private Expression<Object> exprResult;
    private Node node;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprRoles = expressions[0];
        this.exprResult = expressions[1];
        this.node = this.getParser().getNode();
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member[].class});
    }

    protected void execute(@NotNull Event event) {
        List<Member> members;
        Object[] rolesObjs = this.exprRoles.getArray(event);
        if (rolesObjs.length == 0) {
            return;
        }
        Role[] roles = new Role[rolesObjs.length];
        for (int i = 0; i < rolesObjs.length; ++i) {
            Role[] obj = rolesObjs[i];
            if (obj == null) {
                SkriptUtils.error(this.node, "All provided roles must be a role! (one of them is null)");
                return;
            }
            if (!(obj instanceof Role)) {
                SkriptUtils.error(this.node, "All provided roles must be a role! (one of them is not a role)");
                return;
            }
            roles[i] = (Role)obj;
        }
        Guild guild = null;
        for (Role role : roles) {
            if (guild == null) {
                guild = role.getGuild();
                continue;
            }
            if (role.getGuild().equals(guild)) continue;
            SkriptUtils.error(this.node, "All provided roles must be in the same guild!");
            return;
        }
        try {
            members = guild.findMembersWithRoles(roles).get();
        }
        catch (Exception e) {
            DiSkyRuntimeHandler.error(e);
            return;
        }
        this.exprResult.change(event, (Object[])members.toArray(new Member[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "find members with roles " + this.exprRoles.toString(event, debug) + " and store them in " + this.exprResult.toString(event, debug);
    }

    static {
        Skript.registerEffect(FindMembersWithRoles.class, (String[])new String[]{"find [the] [discord] member[s] with [the] role[s] %roles% and store (them|the member[s]) in %~objects%"});
    }
}

