/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Retrieve Interested Members")
@Description(value={"Retrieve all members who are interested in a scheduled event."})
public class RetrieveInterestedMembers
extends AsyncEffect {
    private Expression<ScheduledEvent> exprEvent;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprEvent = expressions[0];
        this.exprBot = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member[].class});
    }

    protected void execute(Event event) {
        List members;
        ScheduledEvent scheduledEvent = (ScheduledEvent)this.exprEvent.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (scheduledEvent == null || bot == null) {
            return;
        }
        scheduledEvent = bot.getInstance().getScheduledEventById(scheduledEvent.getId());
        if (scheduledEvent == null) {
            return;
        }
        try {
            members = (List)scheduledEvent.retrieveInterestedMembers().complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        this.exprResult.change(event, (Object[])members.toArray(new Member[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "retrieve all interested members of scheduled event " + this.exprEvent.toString(e, debug) + (String)(this.exprBot != null ? " using bot " + this.exprBot.toString(e, debug) : "") + " and store them in " + this.exprResult.toString(e, debug);
    }

    static {
        Skript.registerEffect(RetrieveInterestedMembers.class, (String[])new String[]{"retrieve [all] interest[ed] members of [the] [scheduled] event %scheduledevent% [using [the] [bot] %-bot%] and store (it|the members) in %~objects%"});
    }
}

