/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Invite;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class RetrieveInvites
extends AsyncEffect {
    private Expression<Guild> exprGuild;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprGuild = expressions[0];
        this.exprBot = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Invite[].class});
    }

    protected void execute(@NotNull Event event) {
        Object[] invites;
        Guild guild = (Guild)this.exprGuild.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (guild == null || bot == null) {
            return;
        }
        guild = bot.getInstance().getGuildById(guild.getId());
        if (guild == null) {
            return;
        }
        try {
            invites = guild.retrieveInvites().complete().toArray(new Invite[0]);
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        this.exprResult.change(event, invites, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "retrieve invites from guild " + this.exprGuild.toString(e, debug) + (String)(this.exprBot != null ? " using bot " + this.exprBot.toString(e, debug) : "") + " and store it in " + this.exprResult.toString(e, debug);
    }

    static {
        Skript.registerEffect(RetrieveInvites.class, (String[])new String[]{"retrieve [all [of]] [the] invite[s] (from|with|of|in) %guild% [(with|using) [the] [bot] %-bot%] and store (it|them|the invites) in %~objects%"});
    }
}

