/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.audit.AuditLogEntry;
import net.dv8tion.jda.api.entities.Guild;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Retrieve Logs")
@Description(value={"Retrieve the audit logs of a guild."})
@Examples(value={"retrieve audit logs from event-guild and store it in {_logs::*}"})
@Since(value={"4.11.0"})
public class RetrieveLogs
extends AsyncEffect {
    private Expression<Guild> exprGuild;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprGuild = expressions[0];
        this.exprBot = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{AuditLogEntry[].class});
    }

    protected void execute(@NotNull Event event) {
        Object[] logs;
        Guild guild = (Guild)this.exprGuild.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        if (guild == null || bot == null) {
            return;
        }
        guild = bot.getInstance().getGuildById(guild.getId());
        if (guild == null) {
            return;
        }
        try {
            logs = ((List)guild.retrieveAuditLogs().complete()).toArray(new AuditLogEntry[0]);
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        this.exprResult.change(event, logs, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "retrieve audit logs from guild " + this.exprGuild.toString(e, debug) + (String)(this.exprBot == null ? "" : " with bot " + this.exprBot.toString(e, debug)) + " and store them in " + this.exprResult.toString(e, debug);
    }

    static {
        Skript.registerEffect(RetrieveLogs.class, (String[])new String[]{"retrieve [(all|every)] [audit] log[s] [entries] (from|with|of|in) %guild% [(with|using) [the] [bot] %-bot%] and store (them|the [audit] log[s] [entries]) in %~objects%"});
    }
}

