/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetrieveMessage
extends AsyncEffect {
    private Expression<String> exprID;
    private Expression<Channel> exprChannel;
    private Expression<Bot> exprBot;
    private Expression<Object> exprResult;
    private Node node;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprID = expressions[0];
        this.exprChannel = expressions[1];
        this.exprBot = expressions[2];
        this.exprResult = expressions[3];
        this.node = this.getParser().getNode();
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Message.class});
    }

    protected void execute(@NotNull Event event) {
        Message message2;
        String id = (String)this.exprID.getSingle(event);
        Bot bot = Bot.fromContext(this.exprBot, event);
        Channel rawChannel = (Channel)this.exprChannel.getSingle(event);
        if (id == null || bot == null || rawChannel == null) {
            return;
        }
        if (!(rawChannel instanceof MessageChannel)) {
            SkriptUtils.error(this.node, "The channel must be a message channel!");
            return;
        }
        MessageChannel channel = (MessageChannel)rawChannel;
        channel = bot.getInstance().getChannelById(MessageChannel.class, channel.getId());
        if (channel == null) {
            return;
        }
        try {
            message2 = channel.retrieveMessageById(id).complete();
        }
        catch (Exception ex) {
            return;
        }
        this.exprResult.change(event, (Object[])new Message[]{message2}, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "retrieve message with id " + this.exprID.toString(event, b) + " from channel " + this.exprChannel.toString(event, b) + (String)(this.exprBot == null ? "" : " using bot " + this.exprBot.toString(event, b)) + " and store it in " + this.exprResult.toString(event, b);
    }

    static {
        Skript.registerEffect(RetrieveMessage.class, (String[])new String[]{"retrieve message (with|from) id %string% (from|with|of|in) %channel% [(with|using) [the] [bot] %-bot%] and store (it|the message) in %~objects%"});
    }
}

