/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Retrieve Messages")
@Description(value={"Retrieve last X messages from a specific message channel.", "You can retrieve up to 100 last messages, others will be ignored.", "Don't forget to use 'purge' effect to delete a lot of messages the most enhanced way ever."})
@Examples(value={"retrieve last 30 messages from event-channel and store them in {_msg::*}"})
public class RetrieveMessages
extends AsyncEffect {
    private Expression<Number> exprAmount;
    private Expression<MessageChannel> exprChannel;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprAmount = expressions[0];
        this.exprChannel = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Message[].class});
    }

    public void execute(@NotNull Event e) {
        List<Message> messages;
        Number number = (Number)this.exprAmount.getSingle(e);
        MessageChannel channel = (MessageChannel)this.exprChannel.getSingle(e);
        if (number == null || channel == null) {
            return;
        }
        try {
            messages = channel.getHistory().retrievePast(number.intValue()).complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        this.exprResult.change(e, (Object[])messages.toArray(new Message[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "retrieve last " + this.exprAmount.toString(e, debug) + " from " + this.exprChannel.toString(e, debug);
    }

    static {
        Skript.registerEffect(RetrieveMessages.class, (String[])new String[]{"retrieve [last] %number% [amount of] message[s] (of|in|from) %channel% and store (them|the messages) in %-objects%"});
    }
}

