/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import java.util.List;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.requests.restaction.pagination.PinnedMessagePaginationAction;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetrievePinnedMessages
extends AsyncEffect {
    private Expression<Number> exprAmount;
    private Expression<MessageChannel> exprChannel;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.getParser().setHasDelayBefore(Kleenean.TRUE);
        this.exprAmount = expressions[0];
        this.exprChannel = expressions[1];
        this.exprResult = expressions[2];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{PinnedMessagePaginationAction.PinnedMessage[].class});
    }

    public void execute(@NotNull Event e) {
        List<PinnedMessagePaginationAction.PinnedMessage> messages;
        Number number = EasyElement.parseSingle(this.exprAmount, e, -1);
        MessageChannel channel = (MessageChannel)this.exprChannel.getSingle(e);
        if (number == null || channel == null) {
            return;
        }
        try {
            messages = number.intValue() != -1 ? channel.retrievePinnedMessages().takeAsync(number.intValue()).get() : (List<PinnedMessagePaginationAction.PinnedMessage>)channel.retrievePinnedMessages().complete();
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        this.exprResult.change(e, (Object[])messages.toArray(new PinnedMessagePaginationAction.PinnedMessage[0]), Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "retrieve last " + (this.exprAmount == null ? "50" : this.exprAmount.toString(e, debug)) + " pinned messages from " + this.exprChannel.toString(e, debug) + (String)(this.exprResult != null ? " and store them in " + this.exprResult.toString(e, debug) : "");
    }

    static {
        Skript.registerEffect(RetrievePinnedMessages.class, (String[])new String[]{"retrieve [[last] %-number% [amount of]] pinned message[s] (of|in|from) %channel% and store (them|the messages) in %-objects%"});
    }
}

