/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.effects.retrieve;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.util.AsyncEffect;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetrieveWebhooks
extends AsyncEffect {
    private Expression<Object> exprEntity;
    private Expression<Object> exprResult;

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprEntity = expressions[0];
        this.exprResult = expressions[1];
        return Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Webhook[].class});
    }

    protected void execute(@NotNull Event event) {
        Object[] webhooks;
        block5: {
            Object entity = this.exprEntity.getSingle(event);
            if (entity == null) {
                return;
            }
            try {
                if (entity instanceof Guild) {
                    webhooks = ((Guild)entity).retrieveWebhooks().complete().toArray(new Webhook[0]);
                    break block5;
                }
                if (entity instanceof TextChannel) {
                    webhooks = ((TextChannel)entity).retrieveWebhooks().complete().toArray(new Webhook[0]);
                    break block5;
                }
                return;
            }
            catch (Exception ex) {
                DiSkyRuntimeHandler.error(ex);
                return;
            }
        }
        this.exprResult.change(event, webhooks, Changer.ChangeMode.SET);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "retrieve all discord webhooks of " + this.exprEntity.toString(event, debug) + " and store them in " + this.exprResult.toString(event, debug);
    }

    static {
        Skript.registerEffect(RetrieveWebhooks.class, (String[])new String[]{"retrieve [all] [discord] webhooks (of|from) [the] [(guild|channel)] %guild/textchannel% and store (them|the webhooks) in %~objects%"});
    }
}

