/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.events.rework;

import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.guild.GenericGuildEvent;
import net.dv8tion.jda.api.events.guild.GuildJoinEvent;
import net.dv8tion.jda.api.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.api.events.guild.GuildReadyEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.events.session.ShutdownEvent;
import net.itsthesky.disky.api.events.rework.BuiltEvent;
import net.itsthesky.disky.api.events.rework.EventRegistryFactory;

public class BotEvents {
    public static final BuiltEvent<ReadyEvent> READY_EVENT;
    public static final BuiltEvent<GuildReadyEvent> GUILD_READY_EVENT;
    public static final BuiltEvent<ShutdownEvent> SHUTDOWN_EVENT;

    static {
        EventRegistryFactory.builder(GuildJoinEvent.class).name("Bot Join Event").patterns("bot [guild] join[ed]").description("Fired when the bot joins a new guild/server.", "This event is useful for setting up initial configurations when the bot enters a new server,", "such as adding default roles, sending welcome messages, or initializing server-specific settings.").example("on bot join:\n    broadcast \"Bot joined a new server: %event-guild%!\"").value(Guild.class, GenericGuildEvent::getGuild, 0).register();
        EventRegistryFactory.builder(GuildLeaveEvent.class).name("Bot Leave Event").patterns("bot [guild] (leave|left)").description("Fired when the bot leaves a guild/server.", "This event can be used for cleanup operations or logging when the bot is removed from a server,", "either by being kicked, the server being deleted, or the bot owner removing it manually.").example("on bot leave:\n    broadcast \"Bot left the server: %event-guild%\"").value(Guild.class, GenericGuildEvent::getGuild, 0).register();
        SHUTDOWN_EVENT = EventRegistryFactory.builder(ShutdownEvent.class).name("Bot Shutdown Event").patterns("bot (shutdown|stop)").description("Fired when a bot is shutting down or being stopped.", "This event is triggered when the bot's connection to Discord is closing,", "which can happen during server restarts, plugin reloads, or manual bot shutdowns.", "It provides an opportunity to perform cleanup operations or save data before the bot goes offline.").example("on bot shutdown:\n    broadcast \"Bot %event-bot% is shutting down!\"").register();
        GUILD_READY_EVENT = EventRegistryFactory.builder(GuildReadyEvent.class).name("Guild Ready Event").patterns("guild (ready|load[ed])").description("Fired when a guild is fully loaded and all its data is accessible.", "This event occurs for each guild the bot is connected to when starting up.", "It's fired before the global Ready event and indicates that guild-specific data", "like members, channels, and roles have been loaded and are available for use.").example("on guild ready:\n    broadcast \"Guild %event-guild% is now fully loaded!\"").value(Guild.class, GenericGuildEvent::getGuild, 0).register();
        READY_EVENT = EventRegistryFactory.builder(ReadyEvent.class).name("Bot Ready Event").patterns("(ready|bot load[ed])").description("Fired when a bot is fully loaded and connected to Discord.", "This event is triggered once all guilds are ready and the bot's connection to Discord", "is completely established. This is the ideal event to use for initialization code that", "needs to run once when the bot starts up, such as scheduling tasks or initializing resources.").example("on bot loaded:\n    broadcast \"Bot %event-bot% is now online and ready!\"").register();
    }
}

