/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.events.rework;

import ch.njol.skript.util.Date;
import ch.njol.skript.util.Timespan;
import net.dv8tion.jda.api.Region;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.forums.ForumTag;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.events.channel.ChannelCreateEvent;
import net.dv8tion.jda.api.events.channel.ChannelDeleteEvent;
import net.dv8tion.jda.api.events.channel.GenericChannelEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateAppliedTagsEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateArchiveTimestampEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateArchivedEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateAutoArchiveDurationEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateBitrateEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateDefaultLayoutEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateDefaultReactionEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateDefaultSortOrderEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateDefaultThreadSlowmodeEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateFlagsEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateInvitableEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateLockedEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateNSFWEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateNameEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateParentEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdatePositionEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateRegionEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateSlowmodeEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateTopicEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateTypeEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateUserLimitEvent;
import net.dv8tion.jda.api.events.channel.update.ChannelUpdateVoiceStatusEvent;
import net.dv8tion.jda.api.events.channel.update.GenericChannelUpdateEvent;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.events.rework.EventCategory;
import net.itsthesky.disky.api.events.rework.EventRegistryFactory;
import net.itsthesky.disky.core.SkriptUtils;

@EventCategory(name="Channel Events", description={"These events are fired when a channel is created, deleted, or updated.", "This include all types of channels, including text, voice, forum, private, ... channels."})
public class ChannelEvents {
    static {
        EventRegistryFactory.builder(ChannelCreateEvent.class).name("Channel Create Event").patterns("[discord] channel creat(e|ion)").description("Fired when a channel is created.").example("on channel creation:\n    broadcast \"%event-channel%, %event-guild%\"").value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelDeleteEvent.class).name("Channel Delete Event").patterns("[discord] channel delet(e|ion)").description("Fired when a channel is deleted.").example("on channel deletion:\n    broadcast \"%event-channel%, %event-guild%\"").value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateNameEvent.class).name("Channel Name Update Event").patterns("[discord] channel name (change|update)").description("Fired when a channel's name is changed.").example("on channel name change:\n    broadcast \"Channel %event-channel% was renamed from %previous channel name% to %current channel name%\"").customTimedExpressions("[channel] name", String.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateTopicEvent.class).name("Channel Topic Update Event").patterns("[discord] channel topic (change|update)").description("Fired when a channel's topic is changed.").example("on channel topic change:\n    broadcast \"Channel %event-channel% had its topic changed from '%previous channel topic%' to '%current channel topic%'\"").customTimedExpressions("[channel] topic", String.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateNSFWEvent.class).name("Channel NSFW Update Event").patterns("[discord] channel nsfw (change|update)").description("Fired when a channel's NSFW status is changed.").example("on channel nsfw change:\n    broadcast \"Channel %event-channel% NSFW status changed from %past nsfw state% to %current nsfw state%\"").customTimedExpressions("[channel] nsfw state", Boolean.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdatePositionEvent.class).name("Channel Position Update Event").patterns("[discord] channel position (change|update)").description("Fired when a channel's position is changed.").example("on channel position change:\n    broadcast \"Channel %event-channel% position changed from %past channel position% to %current channel position%\"").customTimedExpressions("[chaannel] position", Integer.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateParentEvent.class).name("Channel Parent Update Event").patterns("[discord] channel parent (change|update)").description("Fired when a channel's parent category is changed.").example("on channel parent change:\n    broadcast \"Channel %event-channel% was moved from %past parent% to %parent%\"").customTimedExpressions("[category] parent", Category.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateSlowmodeEvent.class).name("Channel Slowmode Update Event").patterns("[discord] channel slowmode (change|update)").description("Fired when a channel's slowmode setting is changed.").example("on channel slowmode change:\n    broadcast \"Channel %event-channel% slowmode changed from %past channel slowmode% to %new channel slowmode% seconds\"").customTimedExpressions("[channel] slowmode", Number.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateTypeEvent.class).name("Channel Type Update Event").patterns("[discord] channel type (change|update)").description("Fired when a channel's type is changed.").example("on channel type change:\n    broadcast \"Channel %event-channel% type changed from %past channel type% to %current channel type%\"").customTimedExpressions("[channel] type", ChannelType.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateUserLimitEvent.class).name("Channel User Limit Update Event").patterns("[discord] channel user limit (change|update)").description("Fired when a voice channel's user limit is changed.").example("on channel user limit change:\n    broadcast \"Channel %event-channel% user limit changed from %past user limit% to %current user limit%\"").customTimedExpressions("[channel] user limit", Number.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateBitrateEvent.class).name("Channel Bitrate Update Event").patterns("[discord] channel bitrate (change|update)").description("Fired when a voice channel's bitrate is changed.").example("on channel bitrate change:\n    broadcast \"Channel %event-channel% bitrate changed from %past bitrate% to %current bitrate%\"").customTimedExpressions("[channel] bitrate", Number.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateRegionEvent.class).name("Channel Region Update Event").patterns("[discord] channel region (change|update)").description("Fired when a voice channel's region is changed.").example("on channel region change:\n    broadcast \"Channel %event-channel% region changed from %past channel region% to %current channel region%\"").customTimedExpressions("[channel] region", String.class, evt -> evt.getNewValue() == null ? null : ((Region)((Object)((Object)evt.getNewValue()))).name().toLowerCase(), evt -> evt.getOldValue() == null ? null : ((Region)((Object)((Object)evt.getOldValue()))).name().toLowerCase()).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateVoiceStatusEvent.class).name("Channel Voice Status Update Event").patterns("[discord] channel voice status (change|update)").description("Fired when a voice channel's status (video or voice) is changed.").example("on channel voice status change:\n    broadcast \"Channel %event-channel% voice status changed from %past channel voice status% to %current channel voice status%\"").customTimedExpressions("[channel] voice status", String.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateAppliedTagsEvent.class).name("Channel Applied Tags Update Event").patterns("[discord] channel [applied] tags (change|update)").description("Fired when a forum channel's applied tags are changed.").example("on channel tags change:\n    broadcast \"Channel %event-channel% applied tags changed from %old applied tags% to %new applied tags%\"").customTimedListExpressions("[applied] tags", ForumTag.class, evt -> (ForumTag[])evt.getAddedTags().toArray(ForumTag[]::new), evt -> (ForumTag[])evt.getRemovedTags().toArray(ForumTag[]::new)).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateArchivedEvent.class).name("Channel Archived Update Event").patterns("[discord] channel archived (change|update)").description("Fired when a thread channel's archived status is changed.").example("on channel archived change:\n    broadcast \"Channel %event-channel% archived status changed from %past channel archived state% to %current channel archived state%\"").customTimedExpressions("[channel] archive[d] state", Boolean.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateArchiveTimestampEvent.class).name("Channel Archive Timestamp/Date Update Event").patterns("[discord] channel archive (timestam|date) (change|update)").description("Fired when a thread channel's archive timestamp is changed.").example("on channel archive timestamp change:\n    broadcast \"Channel %event-channel% archive timestamp changed from %past channel archive timestamp% to %current channel archive timestamp%\"").customTimedExpressions("[channel] archive (timestamp|date)", Date.class, evt -> SkriptUtils.convertDateTime(evt.getNewValue()), evt -> SkriptUtils.convertDateTime(evt.getOldValue())).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateAutoArchiveDurationEvent.class).name("Channel Auto Archive Duration Update Event").patterns("[discord] channel auto[( |-)]archive duration (change|update)").description("Fired when a thread channel's auto archive duration is changed.").example("on channel auto-archive duration change:\n    broadcast \"Channel %event-channel% auto archive duration changed from %past channel auto archive duration% to %current channel auto archive duration%\"").customTimedExpressions("[channel] auto archive duration", Timespan.class, evt -> evt.getNewValue() == null ? null : new Timespan(Timespan.TimePeriod.MINUTE, (long)((ThreadChannel.AutoArchiveDuration)((Object)((Object)evt.getNewValue()))).getMinutes()), evt -> evt.getOldValue() == null ? null : new Timespan(Timespan.TimePeriod.MINUTE, (long)((ThreadChannel.AutoArchiveDuration)((Object)((Object)evt.getOldValue()))).getMinutes())).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateDefaultLayoutEvent.class).name("Channel Default Layout Update Event").patterns("[discord] channel default layout (change|update)").description("Fired when a forum channel's default layout is changed.").example("on channel default layout change:\n    broadcast \"Channel %event-channel% default layout changed from %old default layout% to %new default layout%\"").customTimedExpressions("[channel] default layout", String.class, evt -> evt.getNewValue().name().toLowerCase(), evt -> evt.getOldValue().name().toLowerCase()).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateDefaultReactionEvent.class).name("Channel Default Reaction Update Event").patterns("[discord] channel default reaction (change|update)").description("Fired when a forum channel's default reaction is changed.").example("on channel default reaction change:\n    broadcast \"Channel %event-channel% default reaction changed from %old default reaction% to %new default reaction%\"").customTimedExpressions("[channel] default reaction", Emote.class, evt -> Emote.fromUnion((EmojiUnion)evt.getNewValue()), evt -> Emote.fromUnion((EmojiUnion)evt.getOldValue())).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateDefaultSortOrderEvent.class).name("Channel Default Sort Order Update Event").patterns("[discord] channel default sort order (change|update)").description("Fired when a forum channel's default sort order is changed.").example("on channel default sort order change:\n    broadcast \"Channel %event-channel% default sort order changed from %old default sort order% to %new default sort order%\"").customTimedExpressions("[channel] default sort order", String.class, evt -> evt.getNewValue().name().toLowerCase(), evt -> evt.getOldValue().name().toLowerCase()).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateDefaultThreadSlowmodeEvent.class).name("Channel Default Thread Slowmode Update Event").patterns("[discord] channel default thread slowmode (change|update)").description("Fired when a forum channel's default thread slowmode is changed.").example("on channel default thread slowmode change:\n    broadcast \"Channel %event-channel% default thread slowmode changed from %old default thread slowmode% to %new default thread slowmode%\"").customTimedExpressions("[channel] default thread slowmode", Number.class, ChannelUpdateDefaultThreadSlowmodeEvent::getNewValue, ChannelUpdateDefaultThreadSlowmodeEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateFlagsEvent.class).name("Channel Flags Update Event").patterns("[discord] channel flags (change|update)").description("Fired when a channel's flags are changed.").example("on channel flags change:\n    broadcast \"Channel %event-channel% flags changed from %old channel flags% to %new channel flags%\"").customTimedListExpressions("[channel] flags", String.class, evt -> (String[])evt.getNewValue().stream().map(Enum::name).map(String::toLowerCase).toArray(String[]::new), evt -> (String[])evt.getOldValue().stream().map(Enum::name).map(String::toLowerCase).toArray(String[]::new)).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateInvitableEvent.class).name("Channel Invitable Update Event").patterns("[discord] channel invitable (change|update)").description("Fired when a thread channel's invitable status is changed.").example("on channel invitable change:\n    broadcast \"Channel %event-channel% invitable status changed from %past channel invitable state% to %current channel invitable state%\"").customTimedExpressions("[channel] invitable [state]", Boolean.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
        EventRegistryFactory.builder(ChannelUpdateLockedEvent.class).name("Channel Locked Update Event").patterns("[discord] channel locked (change|update)").description("Fired when a thread channel's locked status is changed.").example("on channel locked change:\n    broadcast \"Channel %event-channel% locked status changed from %past channel locked state% to %current channel locked state%\"").customTimedExpressions("[channel] locked [state]", Boolean.class, GenericChannelUpdateEvent::getNewValue, GenericChannelUpdateEvent::getOldValue).value(Guild.class, GenericChannelEvent::getGuild).channelValues(GenericChannelEvent::getChannel).author(GenericChannelEvent::getGuild).register();
    }
}

