/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.events.rework;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.sections.SecLoop;
import ch.njol.skript.sections.SecWhile;
import ch.njol.util.Kleenean;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.GenericCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.GenericContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.CommandInteractionPayload;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.itsthesky.disky.api.events.rework.BuiltEvent;
import net.itsthesky.disky.api.events.rework.EventCategory;
import net.itsthesky.disky.api.events.rework.EventRegistryFactory;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.SimpleGetterExpression;
import net.itsthesky.disky.core.JDAUtils;
import net.itsthesky.disky.elements.events.rework.custom.SlashCooldownEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventCategory(name="Interaction Command Events", description={"These events are fired when a user interacts with a command:", "", "- Slash Command: Fired when a user executes a slash command. (+ includes an auto-complete event)", "- Message Command: Fired when a user interacts with a message command (right click on a message).", "- User Command: Fired when a user interacts with a user command (right click on a user).", "", "Refer to individual event documentation for more details."})
public class CommandEvents {
    public static final BuiltEvent<SlashCooldownEvent> SLASH_COOLDOWN_EVENT;
    public static final BuiltEvent<SlashCommandInteractionEvent> SLASH_COMMAND_EVENT;
    public static final BuiltEvent<MessageContextInteractionEvent> MESSAGE_COMMAND_EVENT;
    public static final BuiltEvent<UserContextInteractionEvent> USER_COMMAND_EVENT;
    public static final BuiltEvent<CommandAutoCompleteInteractionEvent> SLASH_COMPLETION_EVENT;

    static {
        SLASH_COMMAND_EVENT = EventRegistryFactory.builder(SlashCommandInteractionEvent.class).name("Slash Command").patterns("slash command [receive[d]]").description("Fired when a user execute a specific slash command.", "Use 'used command' to get the command name. Don't forget to either reply or defer the interaction, You can only defer using the wait pattern  e.g: 'defer the interaction and wait [silently].", "You can get value of arguments using 'argument \"name\" as string' for example.").implementModal(GenericCommandInteractionEvent::replyModal).implementInteraction(evt -> evt).channelValues(SlashCommandInteractionEvent::getChannel).value(String.class, CommandInteractionPayload::getFullCommandName).value(User.class, GenericInteractionCreateEvent::getUser).value(Guild.class, GenericInteractionCreateEvent::getGuild).value(Member.class, GenericInteractionCreateEvent::getMember).singleExpression("(execute|use)[d] [slash] command", String.class, CommandInteractionPayload::getFullCommandName).register();
        SLASH_COOLDOWN_EVENT = EventRegistryFactory.builder(SlashCooldownEvent.class).noRegistration().implementModal(GenericCommandInteractionEvent::replyModal).implementInteraction(evt -> evt).channelValues(SlashCommandInteractionEvent::getChannel).value(String.class, CommandInteractionPayload::getFullCommandName).value(User.class, GenericInteractionCreateEvent::getUser).value(Guild.class, GenericInteractionCreateEvent::getGuild).value(Member.class, GenericInteractionCreateEvent::getMember).cancellable(SlashCooldownEvent::isCancelled, SlashCooldownEvent::setCancelled).register();
        MESSAGE_COMMAND_EVENT = EventRegistryFactory.builder(MessageContextInteractionEvent.class).name("Message Command").patterns("message command [receive[d]]").description("Fired when someone click on a message application command.", "Use `used command` to get the command name and `target message` for the targeted message. Don't forget to either reply to the interaction. Defer doesn't work here.").implementModal(GenericCommandInteractionEvent::replyModal).implementInteraction(evt -> evt).channelValues(MessageContextInteractionEvent::getChannel).value(String.class, GenericCommandInteractionEvent::getName).value(User.class, GenericInteractionCreateEvent::getUser).value(Guild.class, GenericInteractionCreateEvent::getGuild).value(Member.class, GenericInteractionCreateEvent::getMember).value(Message.class, GenericContextInteractionEvent::getTarget).singleExpression("(execute|use)[d] [message] command", String.class, CommandInteractionPayload::getFullCommandName).singleExpression("[the] target message", Message.class, GenericContextInteractionEvent::getTarget).register();
        USER_COMMAND_EVENT = EventRegistryFactory.builder(UserContextInteractionEvent.class).name("User Command").patterns("user command [receive[d]]").description("Fired when someone click on a user application command.", "Use `used command` to get the command name and `target user` for the targeted user. Don't forget to either reply to the interaction. Defer doesn't work here.").implementModal(GenericCommandInteractionEvent::replyModal).implementInteraction(evt -> evt).channelValues(GenericInteractionCreateEvent::getChannel).value(String.class, GenericCommandInteractionEvent::getName).value(User.class, GenericInteractionCreateEvent::getUser).value(Guild.class, GenericInteractionCreateEvent::getGuild).value(Member.class, GenericInteractionCreateEvent::getMember).singleExpression("(execute|use)[d] [user] command", String.class, CommandInteractionPayload::getFullCommandName).singleExpression("[the] target user", User.class, GenericContextInteractionEvent::getTarget).register();
        SLASH_COMPLETION_EVENT = EventRegistryFactory.builder(CommandAutoCompleteInteractionEvent.class).name("Slash Command Completion Event").patterns("slash completion [receive[d]]").description("Fired when Discord requests argument autocompletion for a slash command.", "Use 'event-string' to get the command name.", "Use the 'return' effect to provide completion choices to the user.", "You can access the focused argument with 'current argument' and other argument values with 'argument \"name\" as type'.").example("on slash completion:\n    if event-string is \"mycommand\":\n        if current argument is \"option\":\n            return choice \"Option 1\" with value \"option1\", choice \"Option 2\" with value \"option2\"").implementInteraction(evt -> evt).channelValues(CommandAutoCompleteInteractionEvent::getChannel).value(Guild.class, GenericInteractionCreateEvent::getGuild).value(Member.class, GenericInteractionCreateEvent::getMember).value(User.class, GenericInteractionCreateEvent::getUser).value(String.class, CommandInteractionPayload::getFullCommandName).singleExpression("current( |-)arg[ument] [name]", String.class, evt -> evt.getInteraction().getFocusedOption().getName()).register();
        Skript.registerEffect(ReturnCompletions.class, (String[])new String[]{"return %slashchoices%"});
    }

    public static class ReturnCompletions
    extends Effect {
        private Expression<Command.Choice> exprChoices;

        protected void execute(@NotNull Event e) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        protected TriggerItem walk(@NotNull Event e) {
            this.debug(e, false);
            Command.Choice[] choices = EasyElement.parseList(this.exprChoices, e, new Command.Choice[0]);
            if (choices.length == 0) {
                return null;
            }
            CommandAutoCompleteInteractionEvent event = SLASH_COMPLETION_EVENT.getJDAEvent(e);
            if (event != null) {
                event.replyChoices(choices).queue();
            }
            for (TriggerSection parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof SecLoop) {
                    ((SecLoop)parent).exit(e);
                    continue;
                }
                if (!(parent instanceof SecWhile)) continue;
                ((SecWhile)parent).exit(e);
            }
            return null;
        }

        @NotNull
        public String toString(@Nullable Event e, boolean debug) {
            return "return choices " + this.exprChoices.toString(e, debug);
        }

        public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
            if (!EasyElement.containsEvent(SLASH_COMPLETION_EVENT.getBukkitEventClass())) {
                return false;
            }
            this.exprChoices = exprs[0];
            return true;
        }
    }

    @Name(value="Slash Command Argument")
    @Description(value={"Represents a slash command argument.", "The name is the ID used when defining the slash command.", "Specify the type, so that Skript can parse it correctly. (if it's a number, operation wil be allowed for example)", "The type should be the same used when defining the argument in the command."})
    @Examples(value={"# I'm doing /ban time:30 user:*user id*, so:", "set {_time} to argument \"time\" as integer", "set {_user} to argument \"user\" as user"})
    public static class ArgValue
    extends SimpleGetterExpression<Object, Event> {
        private Expression<String> exprName;
        private OptionType type;
        private boolean isMember;

        @Override
        public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
            if (!super.init(exprs, matchedPattern, isDelayed, parseResult)) {
                return false;
            }
            this.exprName = exprs[0];
            this.isMember = parseResult.hasTag("member");
            if (!this.isMember) {
                this.type = (OptionType)((Object)exprs[1].getSingle(null));
                if (this.type == null) {
                    Skript.error((String)"You must provide a literal (= constant) value for the option type.");
                    return false;
                }
            } else {
                this.type = OptionType.USER;
            }
            return true;
        }

        @Override
        protected String getValue() {
            return "argument " + this.exprName.toString(null, false);
        }

        @Override
        protected Class<Event> getEvent() {
            throw new UnsupportedOperationException("This method should not be called.");
        }

        @Override
        public Class<Event>[] getCompatibleEvents() {
            return new Class[]{SLASH_COMMAND_EVENT.getBukkitEventClass(), SLASH_COOLDOWN_EVENT.getBukkitEventClass(), SLASH_COMPLETION_EVENT.getBukkitEventClass()};
        }

        @Override
        protected Object convert(Event e) {
            Guild guild;
            boolean isFromGuild;
            OptionMapping option;
            String name = EasyElement.parseSingle(this.exprName, e, null);
            if (name == null) {
                return null;
            }
            if (SLASH_COMMAND_EVENT.getBukkitEventClass().isAssignableFrom(e.getClass())) {
                option = SLASH_COMMAND_EVENT.getJDAEvent(e).getOption(name);
                isFromGuild = SLASH_COMMAND_EVENT.getJDAEvent(e).isFromGuild();
                guild = SLASH_COMMAND_EVENT.getJDAEvent(e).getGuild();
            } else if (SLASH_COMPLETION_EVENT.getBukkitEventClass().isAssignableFrom(e.getClass())) {
                option = SLASH_COMPLETION_EVENT.getJDAEvent(e).getOption(name);
                isFromGuild = SLASH_COMPLETION_EVENT.getJDAEvent(e).isFromGuild();
                guild = SLASH_COMPLETION_EVENT.getJDAEvent(e).getGuild();
            } else {
                option = null;
                isFromGuild = false;
                guild = null;
            }
            if (option == null) {
                return null;
            }
            if (this.isMember) {
                User user = option.getAsUser();
                if (!isFromGuild) {
                    Skript.error((String)"You cannot get a member from a private channel slash command.");
                    return null;
                }
                return Objects.requireNonNull(guild).getMember(user);
            }
            return JDAUtils.parseOptionValue(option);
        }

        @NotNull
        public Class<?> getReturnType() {
            return JDAUtils.getOptionClass(this.type);
        }

        static {
            Skript.registerExpression(ArgValue.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] arg[ument] [(named|with name)] %string% as (%-optiontype%|:member)"});
        }
    }
}

