/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.events.rework;

import java.util.Objects;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.interaction.GenericInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.interactions.callbacks.IModalCallback;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.itsthesky.disky.api.events.rework.BuiltEvent;
import net.itsthesky.disky.api.events.rework.EventCategory;
import net.itsthesky.disky.api.events.rework.EventRegistryFactory;

@EventCategory(name="Component Interaction Events", description={"Events that are fired when a component is interacted with.", "This includes buttons, select menus, and modals.", "", "!!! info \"Check individual details to see if you are able to show a modal!\""})
public class ComponentEvents {
    public static final BuiltEvent<ModalInteractionEvent> MODAL_INTERACTION_EVENT;

    static {
        EventRegistryFactory.builder(ButtonInteractionEvent.class).name("Button Click").description("Fired when any button sent by the button is clicked.", "You can use the `clicked id` to get the clicked button id.", "", "!!! info \"Modal can be shown in this interaction!\"").patterns("button click[ed]").example("on button clicked:\n    reply with hidden \"You clicked the button with id '%clicked id%'!\" # This will defer the interaction!").implementComponentInteraction(evt -> evt).implementModal(IModalCallback::replyModal).channelValues(GenericComponentInteractionCreateEvent::getChannel).value(String.class, GenericComponentInteractionCreateEvent::getComponentId).value(Button.class, ButtonInteractionEvent::getButton).value(Guild.class, GenericInteractionCreateEvent::getGuild).value(User.class, GenericInteractionCreateEvent::getUser).value(Member.class, GenericInteractionCreateEvent::getMember).value(Number.class, GenericComponentInteractionCreateEvent::getMessageIdLong).value(Message.class, GenericComponentInteractionCreateEvent::getMessage).singleExpression("click[ed] (id|button)", String.class, ComponentInteraction::getComponentId).register();
        MODAL_INTERACTION_EVENT = EventRegistryFactory.builder(ModalInteractionEvent.class).name("Modal Received").description("Fired when a modal has been sent to the bot from any user.", "Use 'received modal' to get the modal id. Don't forget to either reply or defer the interaction.", "", "!!! warning \"Modal can NOT be shown in this interaction!\"").patterns("modal (click[ed]|receive[d])").example("on modal received:\n    reply with hidden \"You clicked the button with id '%received modal%'!\" # This will defer the interaction!").implementInteraction(evt -> evt).channelValues(ModalInteractionEvent::getChannel).value(String.class, ModalInteractionEvent::getModalId).value(Guild.class, GenericInteractionCreateEvent::getGuild).value(User.class, GenericInteractionCreateEvent::getUser).value(Member.class, GenericInteractionCreateEvent::getMember).value(Number.class, evt -> Objects.requireNonNull(evt.getMessage()).getIdLong()).value(Message.class, ModalInteractionEvent::getMessage).singleExpression("receive[d] (id|modal)", String.class, ModalInteractionEvent::getModalId).register();
    }
}

