/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.ColorRGB;
import ch.njol.util.Kleenean;
import java.awt.Color;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Color from Hex")
@Description(value={"Get a color from a hexadecimal string.", "Do not include the # in the string."})
@Examples(value={"set embed color of embed to hex \"ff0000\""})
public class ColorFromHex
extends SimpleExpression<ch.njol.skript.util.Color> {
    private Expression<String> exprHex;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprHex = exprs[0];
        return true;
    }

    protected ch.njol.skript.util.Color @NotNull [] get(@NotNull Event e) {
        Color awtColor;
        Object hex = EasyElement.parseSingle(this.exprHex, e, null);
        if (hex == null) {
            return new ch.njol.skript.util.Color[0];
        }
        if (!((String)hex).startsWith("#")) {
            hex = "#" + (String)hex;
        }
        try {
            awtColor = Color.decode((String)hex);
        }
        catch (NumberFormatException ex) {
            Skript.error((String)("The hex string provided (" + (String)hex + ") is not a valid hexadecimal number."));
            return new ch.njol.skript.util.Color[0];
        }
        return new ch.njol.skript.util.Color[]{new ColorRGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue())};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ch.njol.skript.util.Color> getReturnType() {
        return ch.njol.skript.util.Color.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the hex color " + this.exprHex.toString(e, debug);
    }

    static {
        Skript.registerExpression(ColorFromHex.class, ch.njol.skript.util.Color.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] (hex|color) %string%"});
    }
}

