/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.changers.IAsyncGettableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Get Sticker")
@Description(value={"Get a cached sticker from its per-guild name", "This expression is here to get a sticker from its name.", "If you success to get a sticker's ID, use the retrieve sticker effect instead!", "This expression cannot be changed"})
@Examples(value={"sticker with named \"meliodas\" from event-guild"})
public class GetSticker
extends SimpleExpression<Sticker>
implements IAsyncGettableExpression<Sticker> {
    private Expression<String> exprId;
    private Expression<Guild> exprGuild;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprId = exprs[0];
        this.exprGuild = exprs[1];
        return true;
    }

    protected Sticker @NotNull [] get(@NotNull Event e) {
        String id = (String)this.exprId.getSingle(e);
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (EasyElement.anyNull(this, id, guild)) {
            return new Sticker[0];
        }
        return new Sticker[]{guild.getStickersByName(id, false).stream().findFirst().orElse(null)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Sticker> getReturnType() {
        return Sticker.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "sticker with name " + this.exprId.toString(e, debug) + " in " + this.exprGuild.toString(e, debug);
    }

    public Sticker[] getAsync(Event e) {
        Sticker[] stickerArray;
        String id = (String)this.exprId.getSingle(e);
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (EasyElement.anyNull(this, id, guild)) {
            return new Sticker[0];
        }
        Sticker found = guild.getStickersByName(id, false).stream().findFirst().orElse(null);
        if (found != null) {
            return new Sticker[]{found};
        }
        List retrieveFound = guild.retrieveStickers().complete().stream().filter(sticker -> sticker.getName().equalsIgnoreCase(id)).collect(Collectors.toList());
        if (retrieveFound.isEmpty()) {
            stickerArray = new Sticker[]{};
        } else {
            Sticker[] stickerArray2 = new Sticker[1];
            stickerArray = stickerArray2;
            stickerArray2[0] = (Sticker)retrieveFound.get(0);
        }
        return stickerArray;
    }

    static {
        Skript.registerExpression(GetSticker.class, Sticker.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[get] [the] sticker (with name|named) %string% (from|in|of) [the] [guild] %guild%"});
    }
}

