/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.getters.BaseGetterExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Get Thread Channel")
@Description(value={"Get a thread channel from a guild using its unique ID.", "Threads are global on discord, means different threads cannot have the same ID.", "This expression cannot be changed."})
@Examples(value={"thread with id \"000\""})
public class GetThread
extends BaseGetterExpression<ThreadChannel> {
    @Override
    protected ThreadChannel get(String id, Bot bot) {
        return bot.getInstance().getThreadChannelById(id);
    }

    @Override
    public String getCodeName() {
        return "thread";
    }

    @NotNull
    public Class<? extends ThreadChannel> getReturnType() {
        return ThreadChannel.class;
    }

    static {
        GetThread.register(GetThread.class, ThreadChannel.class, "thread [channel]");
    }
}

