/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.core.SkriptUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Member Boost Date")
@Description(value={"Get the date when a member started boosting the server. Returns null if the member is not boosting."})
@Examples(value={"set {_time} to boost date of event-member", "send \"Member has been boosting since: %boost date of {_member}%\"", "This expression cannot be changed."})
public class GetTimeBoosted
extends SimplePropertyExpression<Member, Date> {
    @Nullable
    public Date convert(Member member) {
        return SkriptUtils.convertDateTime(member.getTimeBoosted());
    }

    @NotNull
    protected String getPropertyName() {
        return "boost date";
    }

    @NotNull
    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        GetTimeBoosted.register(GetTimeBoosted.class, Date.class, (String)"[discord] boost[ing] date", (String)"member");
    }
}

