/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.getters;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.utils.FileUpload;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.reflects.ReflectChangeablePropertyFactory;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class NewFileUpload
extends SimpleExpression<FileUpload> {
    private Node node;
    private FileSource fileSource;
    private Expression<Object> exprSource;
    private Expression<String> exprName;
    private Expression<Boolean> exprSpoiler;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        this.fileSource = FileSource.values()[matchedPattern];
        this.exprSource = expressions[0];
        this.exprName = expressions[1];
        this.exprSpoiler = expressions[2];
        return true;
    }

    protected FileUpload @Nullable [] get(Event event) {
        Object source2 = EasyElement.parseSingle(this.exprSource, event, null);
        Object fileName = EasyElement.parseSingle(this.exprName, event, null);
        Boolean spoiler = EasyElement.parseSingle(this.exprSpoiler, event, false);
        if (source2 == null) {
            DiSkyRuntimeHandler.exprNotSet(this.node, this.exprSource);
            return new FileUpload[0];
        }
        FileUpload upload = null;
        switch (this.fileSource) {
            case IMAGE: {
                BufferedImage image = (BufferedImage)source2;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", baos);
                }
                catch (Exception e) {
                    DiSkyRuntimeHandler.error(e, this.node);
                    return new FileUpload[0];
                }
                String hash = Integer.toHexString(image.hashCode());
                fileName = fileName != null ? fileName : "image-" + hash + ".png";
                try {
                    upload = FileUpload.fromData(baos.toByteArray(), (String)fileName);
                    break;
                }
                catch (Exception e) {
                    DiSkyRuntimeHandler.error(e, this.node);
                    return new FileUpload[0];
                }
            }
            case ATTACHMENT: {
                if (!(source2 instanceof Message.Attachment)) {
                    DiSkyRuntimeHandler.error(new IllegalArgumentException("Expected a FileUpload for attachment, got: " + source2.getClass().getSimpleName()), this.node, false);
                    return new FileUpload[0];
                }
                Message.Attachment attachment = (Message.Attachment)source2;
                fileName = fileName != null ? fileName : attachment.getFileName();
                try {
                    InputStream stream = attachment.getProxy().download().get();
                    if (stream == null) {
                        DiSkyRuntimeHandler.error(new IllegalArgumentException("Failed to download attachment: " + attachment.getFileName()), this.node, false);
                        return new FileUpload[0];
                    }
                    upload = FileUpload.fromData(stream, (String)fileName);
                    break;
                }
                catch (Exception e) {
                    DiSkyRuntimeHandler.error(e, this.node);
                    return new FileUpload[0];
                }
            }
            case URL: {
                String url = source2.toString();
                if (url.isBlank()) {
                    DiSkyRuntimeHandler.error(new IllegalArgumentException("URL cannot be blank"), this.node, false);
                    return new FileUpload[0];
                }
                try {
                    InputStream stream = new URL(url).openStream();
                    Object foundFileName = url.substring(url.lastIndexOf(47) + 1);
                    if (((String)foundFileName).isBlank()) {
                        foundFileName = "file-" + Integer.toHexString(url.hashCode()) + ".txt";
                    }
                    fileName = fileName != null ? fileName : foundFileName;
                    upload = FileUpload.fromData(stream, (String)fileName);
                    break;
                }
                catch (MalformedURLException e) {
                    DiSkyRuntimeHandler.error(new IllegalArgumentException("Invalid URL: " + url, e), this.node, false);
                    return new FileUpload[0];
                }
                catch (Exception e) {
                    DiSkyRuntimeHandler.error(e, this.node);
                    return new FileUpload[0];
                }
            }
            case LOCAL_FILE: {
                String filePath = source2.toString();
                if (filePath.isBlank()) {
                    DiSkyRuntimeHandler.error(new IllegalArgumentException("File path cannot be blank"), this.node, false);
                    return new FileUpload[0];
                }
                File file = new File(filePath);
                if (!file.exists() || !file.isFile()) {
                    DiSkyRuntimeHandler.error(new IllegalArgumentException("File does not exist: " + filePath), this.node, false);
                    return new FileUpload[0];
                }
                fileName = fileName != null ? fileName : file.getName();
                upload = FileUpload.fromData(file);
            }
        }
        if (upload == null || fileName == null) {
            return new FileUpload[0];
        }
        upload = (spoiler != false ? upload.asSpoiler() : upload).setName((String)fileName);
        return new FileUpload[]{upload};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends FileUpload> getReturnType() {
        return FileUpload.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        String suffix = (String)(this.exprName != null ? " with name " + this.exprName.toString(event, debug) : "") + (String)(this.exprSpoiler != null ? " with spoiler " + this.exprSpoiler.toString(event, debug) : "");
        String qualifier = switch (this.fileSource) {
            default -> throw new IncompatibleClassChangeError();
            case FileSource.LOCAL_FILE -> "local file";
            case FileSource.URL -> "url";
            case FileSource.ATTACHMENT -> "attachment";
            case FileSource.IMAGE -> "image";
        };
        return "new file data from " + qualifier + " " + this.exprSource.toString(event, debug) + suffix;
    }

    static {
        String suffix = "[(with name|named) %-string%] [with spoiler %-boolean%]";
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("[new] file (data|upload) from [local] file %string% [(with name|named) %-string%] [with spoiler %-boolean%]");
        patterns.add("[new] file (data|upload) from ur(l|i) %string% [(with name|named) %-string%] [with spoiler %-boolean%]");
        patterns.add("[new] file (data|upload) from attachment %attachment% [(with name|named) %-string%] [with spoiler %-boolean%]");
        if (DiSky.isSkImageInstalled()) {
            patterns.add("[new] file (data|upload) from image %image% [(with name|named) %-string%] [with spoiler %-boolean%]");
        }
        Skript.registerExpression(NewFileUpload.class, FileUpload.class, (ExpressionType)ExpressionType.COMBINED, (String[])patterns.toArray(new String[0]));
        ReflectChangeablePropertyFactory.registerChangeable("fileupload", "file name", FileUpload.class, String.class, "file name", FileUpload::getName, mode -> {
            Class[] classArray;
            if (mode == Changer.ChangeMode.SET) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = String.class;
            } else {
                classArray = null;
            }
            return classArray;
        }, (fileUpload, changeData) -> {
            String newName;
            if (changeData.getMode() == Changer.ChangeMode.SET && (newName = (String)changeData.getFirstDelta()) != null) {
                fileUpload.setName(newName);
            }
            return null;
        });
    }

    public static enum FileSource {
        LOCAL_FILE,
        URL,
        ATTACHMENT,
        IMAGE;

    }
}

