/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.dv8tion.jda.api.components.ActionComponent;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.itsthesky.disky.elements.componentsv2.base.INewComponentBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Discord ID")
@Description(value={"Get the unique long value (ID) that represent a discord entity."})
@Examples(value={"discord id of event-channel", "discord id of event-guild"})
public class DiscordId
extends SimplePropertyExpression<Object, String> {
    @NotNull
    protected String getPropertyName() {
        return "discord id";
    }

    @Nullable
    public String convert(Object entity) {
        if (entity instanceof ISnowflake) {
            ISnowflake snowflake = (ISnowflake)entity;
            return snowflake.getId();
        }
        if (entity instanceof ActionComponent) {
            ActionComponent component = (ActionComponent)entity;
            return component.getCustomId();
        }
        if (entity instanceof INewComponentBuilder) {
            INewComponentBuilder newComponentBuilder = (INewComponentBuilder)entity;
            return newComponentBuilder.getCustomId();
        }
        return null;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        DiscordId.register(DiscordId.class, String.class, (String)"discord id", (String)"channel/role/user/threadchannel/scheduledevent/member/sticker/message/dropdown/button/guild/applicationinfo/webhook/newcomponent");
    }
}

