/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import net.itsthesky.disky.elements.componentsv2.base.sub.FileDisplayBuilder;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Name of Discord Entity")
@Description(value={"This represent the current name of any discord entity that can hold one.", "You can change name of every entity except member and user by defining a new text.", "Check for 'nickname of member' if you want to check / change custom member's name."})
@Examples(value={"discord name of event-guild"})
public class DiscordName
extends SimplePropertyExpression<Object, String>
implements IAsyncChangeableExpression {
    private Node node;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @NotNull
    protected String getPropertyName() {
        return "discord name";
    }

    public @Nullable Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = String.class;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    public void change(@NotNull Event e, @Nullable @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        this.change(e, delta, mode, false);
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    private void change(Event event, Object[] delta, Changer.ChangeMode mode, boolean async) {
        String name;
        Object entity = this.getExpr().getSingle(event);
        String string = name = delta.length == 0 ? null : (String)delta[0];
        if (name == null || entity == null) {
            return;
        }
        Object action = entity instanceof GuildChannel ? ((GuildChannel)entity).getManager().setName(name) : (entity instanceof Role ? ((Role)entity).getManager().setName(name) : (entity instanceof Bot ? ((Bot)entity).getInstance().getSelfUser().getManager().setName(name) : null));
        if (action != null) {
            try {
                if (async) {
                    action.complete();
                } else {
                    action.queue();
                }
            }
            catch (Exception ex) {
                DiSkyRuntimeHandler.error(ex, this.node);
            }
        }
    }

    @Nullable
    public String convert(Object entity) {
        if (entity instanceof Channel) {
            return ((Channel)entity).getName();
        }
        if (entity instanceof Role) {
            return ((Role)entity).getName();
        }
        if (entity instanceof Member) {
            return ((Member)entity).getUser().getName();
        }
        if (entity instanceof User) {
            return ((User)entity).getName();
        }
        if (entity instanceof Guild) {
            return ((Guild)entity).getName();
        }
        if (entity instanceof Emote) {
            return ((Emote)entity).getName();
        }
        if (entity instanceof Sticker) {
            return ((Sticker)entity).getName();
        }
        if (entity instanceof ScheduledEvent) {
            return ((ScheduledEvent)entity).getName();
        }
        if (entity instanceof MessageEmbed.Field) {
            return ((MessageEmbed.Field)entity).getName();
        }
        if (entity instanceof ApplicationInfo) {
            return ((ApplicationInfo)entity).getName();
        }
        if (entity instanceof Webhook) {
            return ((Webhook)entity).getName();
        }
        if (entity instanceof FileDisplayBuilder) {
            return ((FileDisplayBuilder)entity).getFileName();
        }
        return null;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        DiscordName.register(DiscordName.class, String.class, (String)"[the] discord name", (String)"channel/user/member/sticker/scheduledevent/emote/threadchannel/role/guild/embedfield/applicationinfo/webhook/newcomponent");
    }
}

