/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.util.coll.CollectionUtils;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.requests.restaction.AuditableRestAction;
import net.itsthesky.disky.api.changers.MultipleChangeablePropertyExpression;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Guild / Member Roles")
@Description(value={"Represent the roles that a guild or a member currently have.", "Can be changed, SET and ADD ChangeMode can be used when passing a member.", "To modify guild's roles, check delete and create role effects."})
@Examples(value={"add role with id \"000\" to roles of event-member", "remove event-role from roles of event-member", "reply with \"Amount of roles in the guild: %size of roles of event-guild%\""})
public class DiscordRoles
extends MultipleChangeablePropertyExpression<Object, Role>
implements IAsyncChangeableExpression {
    @Override
    public void change(Event e, @NotNull Object[] delta, Bot bot, Changer.ChangeMode mode) {
        this.change(e, delta, mode, false);
    }

    protected Role[] convert(Object entity) {
        if (entity instanceof Member) {
            return ((Member)entity).getRoles().toArray(new Role[0]);
        }
        if (entity instanceof Guild) {
            return ((Guild)entity).getRoles().toArray(new Role[0]);
        }
        return new Role[0];
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (EasyElement.equalAny(mode, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Role.class});
        }
        return new Class[0];
    }

    @Override
    @NotNull
    public Class<? extends Role> getReturnType() {
        return Role.class;
    }

    @Override
    protected String getPropertyName() {
        return "roles";
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    private void change(Event e, Object[] delta, Changer.ChangeMode mode, boolean async) {
        Role role = (Role)delta[0];
        Object entity = this.getExpr().getSingle(e);
        if (EasyElement.anyNull(this, role, entity)) {
            return;
        }
        if (!(entity instanceof Member)) {
            return;
        }
        AuditableRestAction<Void> action = mode == Changer.ChangeMode.ADD ? ((Member)entity).getGuild().addRoleToMember((Member)entity, role) : ((Member)entity).getGuild().removeRoleFromMember((Member)entity, role);
        if (async) {
            action.complete();
        } else {
            action.queue();
        }
    }

    static {
        DiscordRoles.register(DiscordRoles.class, Role.class, "roles", "guild/member");
    }
}

