/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.attachments;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import java.nio.file.Paths;
import net.dv8tion.jda.api.entities.Message;
import net.itsthesky.disky.api.skript.WaiterEffect;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Download Attachment")
@Description(value={"Download the specific attachment to a file path."})
@Examples(value={"download {_attachment} in folder \"plugins/data/attachments/\""})
public class EffAttDownload
extends WaiterEffect {
    private Expression<Message.Attachment> exprAtt;
    private Expression<String> exprPath;

    public boolean initEffect(Expression @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.exprAtt = exprs[0];
        this.exprPath = exprs[1];
        return true;
    }

    @Override
    public void runEffect(@NotNull Event e) {
        Message.Attachment attachment = (Message.Attachment)this.exprAtt.getSingle(e);
        String path = (String)this.exprPath.getSingle(e);
        if (attachment == null || path == null) {
            return;
        }
        File file = new File(path);
        if (!file.isDirectory() && file.exists()) {
            file.delete();
        }
        if (file.isDirectory()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            for (File parent = file.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
                parent.mkdirs();
            }
        }
        try {
            attachment.getProxy().downloadToPath(file.isDirectory() ? Paths.get(file.getPath() + "/" + attachment.getFileName(), new String[0]) : Paths.get(file.getPath(), new String[0]));
        }
        catch (Exception ex) {
            DiSkyRuntimeHandler.error(ex);
        }
        this.restart();
    }

    @NotNull
    public String toString(Event e, boolean debug) {
        return "download attachment " + this.exprAtt.toString(e, debug) + " to folder " + this.exprPath.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAttDownload.class, (String[])new String[]{"(download|dl) [the] [attachment] %attachment% (in|to) [the] [(folder|path)] %string%"});
    }
}

