/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.bot;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bot Self Member")
@Description(value={"Get the self member instance of a bot, in a specific guild."})
@Examples(value={"self member of event-bot in event-guild", "self member of bot \"name\""})
@Since(value={"4.9.0"})
public class SelfMember
extends SimpleExpression<Member> {
    private Expression<Bot> exprBot;
    private Expression<Guild> exprGuild;

    public boolean init(Expression<?>[] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprBot = exprs[0];
        this.exprGuild = exprs[1];
        return true;
    }

    protected Member @NotNull [] get(@NotNull Event e) {
        Bot bot = EasyElement.parseSingle(this.exprBot, e);
        Guild guild = EasyElement.parseSingle(this.exprGuild, e);
        if (bot == null || guild == null) {
            return new Member[0];
        }
        if (!guild.getJDA().equals(bot.getInstance())) {
            return new Member[]{guild.getMember(bot.getInstance().getSelfUser())};
        }
        return new Member[]{guild.getSelfMember()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Member> getReturnType() {
        return Member.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "self member of " + this.exprBot.toString(e, debug) + " in " + this.exprGuild.toString(e, debug);
    }

    static {
        Skript.registerExpression(SelfMember.class, Member.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] self [member] of [the] [bot] %bot% [in [the] [guild] %guild%]", "[the] [bot] %bot%'s self [member] [in [the] [guild] %guild%]"});
    }
}

