/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.channels;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.attribute.IVoiceStatusChannel;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.requests.restaction.ChannelAction;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.action.ActionProperty;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChannelStatus
extends ActionProperty<GuildChannel, ChannelAction, String> {
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode.equals((Object)Changer.ChangeMode.SET)) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = String.class;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    @Override
    public void change(GuildChannel channel, String value, boolean async) {
        if (!(channel instanceof IVoiceStatusChannel)) {
            Skript.error((String)"The channel status can only be applied on voice channel!");
            return;
        }
        if (value.length() >= 500) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The channel status cannot be more than 500 characters long! (got " + value.length() + " characters)"), this.node);
            return;
        }
        Member selfMember = channel.getGuild().getSelfMember();
        if (channel.getGuild().getAudioManager().getConnectedChannel() == null && !selfMember.hasPermission(Permission.MANAGE_SERVER)) {
            DiSkyRuntimeHandler.error(new InsufficientPermissionException(channel, Permission.MANAGE_SERVER), this.node);
            return;
        }
        AudioChannelUnion connectedChannel = channel.getGuild().getAudioManager().getConnectedChannel();
        if (connectedChannel != null && !selfMember.hasPermission(Permission.VOICE_SET_STATUS) && connectedChannel.getMembers().contains(selfMember)) {
            DiSky.runtimeError("DiSky cannot set the channel status without the VOICE_SET_STATUS permission!", "Target Channel", channel.getName() + " [" + channel.getId() + "]", "Permission Required", "VOICE_SET_STATUS");
            return;
        }
        ((IVoiceStatusChannel)((Object)channel)).modifyStatus(value).queue();
    }

    @Override
    public ChannelAction change(ChannelAction action, String value) {
        DiSkyRuntimeHandler.error(new IllegalStateException("Cannot change the status of a voice channel before its creation."), this.node);
        return action;
    }

    @Override
    public String get(GuildChannel role, boolean async) {
        return ((VoiceChannel)role).getStatus();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "channel status";
    }

    static {
        ChannelStatus.register(ChannelStatus.class, String.class, (String)"[voice] channel status", (String)"channel");
    }
}

