/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.embeds;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

public class ExprNewField
extends SimpleExpression<MessageEmbed.Field> {
    private Node node;
    private Expression<String> exprName;
    private Expression<String> exprDesc;
    private boolean isInline;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        this.exprName = expressions[0];
        this.exprDesc = expressions[1];
        this.isInline = parseResult.hasTag("inline");
        return true;
    }

    protected MessageEmbed.Field @Nullable [] get(Event event) {
        String name = (String)this.exprName.getSingle(event);
        String desc = (String)this.exprDesc.getSingle(event);
        if (name == null || desc == null) {
            return null;
        }
        if (name.length() > 256) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The title of a field cannot be bigger than 256 characters. The one you're trying to set is '" + name.length() + "' length!"), this.node);
            return new MessageEmbed.Field[0];
        }
        if (desc.length() > 4096) {
            DiSkyRuntimeHandler.error(new IllegalArgumentException("The value of a field cannot be bigger than 1024 characters. The one you're trying to set is '" + desc.length() + "' length!"), this.node);
            return new MessageEmbed.Field[0];
        }
        return new MessageEmbed.Field[]{new MessageEmbed.Field(name, desc, this.isInline)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends MessageEmbed.Field> getReturnType() {
        return MessageEmbed.Field.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "new field with named " + this.exprName.toString(event, debug) + " with description " + this.exprDesc.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprNewField.class, MessageEmbed.Field.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"new [:inline] [embed] field (named|with name) %string% [and] with [the] value %string%"});
    }
}

