/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.emotes;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.itsthesky.disky.api.emojis.Emote;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Emote Image URL")
@Description(value={"Get the URL of this emote.", "Only emote have image URL, emoji are from Discord and will therefore return none here."})
@Examples(value={"emote url of event-emote", "emote image of reaction \"disky\" # Custom emoji only"})
public class EmoteURL
extends SimplePropertyExpression<Emote, String> {
    @NotNull
    protected String getPropertyName() {
        return "emote image url";
    }

    @Nullable
    public String convert(Emote emote) {
        return emote.isCustom() ? emote.getEmote().getImageUrl() : null;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        EmoteURL.register(EmoteURL.class, String.class, (String)"[the] emo(te|ji) image [url]", (String)"emote");
    }
}

