/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.events;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.properties.events.SimpleScheduledEventExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Cover of Scheduled Event")
@Description(value={"Get the cover of a scheduled event.", "Links to a potentially heavily compressed image. You can append a size parameter to the URL if needed. Example: ?size=4096", "This can returns null if no cover is set for the event."})
@Since(value={"4.8.0"})
public class EventCover
extends SimpleScheduledEventExpression<String> {
    @NotNull
    protected String getPropertyName() {
        return "scheduled event cover";
    }

    @Nullable
    public String convert(ScheduledEvent scheduledEvent) {
        return scheduledEvent.getImageUrl();
    }

    @Override
    public RestAction<?> change(ScheduledEvent entity, Object[] delta) {
        String cover = delta[0] == null ? null : (String)delta[0];
        Icon icon = cover == null ? null : SkriptUtils.parseIcon(cover);
        return entity.getManager().setImage(icon);
    }

    @Override
    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        EventCover.register(EventCover.class, String.class, (String)"scheduled [event] cover", (String)"scheduledevent");
    }
}

