/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.forums;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Default Forum Emoji")
@Description(value={"Represent the default emoji of a forum channel.", "It's the mote that is added automatically once a new post is created.", "Can return none and can be changed."})
@Examples(value={"set default emoji of event-forumchannel to reaction \"smile\""})
public class DefaultEmoji
extends SimplePropertyExpression<ForumChannel, Emote>
implements IAsyncChangeableExpression {
    @Nullable
    public Emote convert(ForumChannel forumChannel) {
        if (forumChannel.getDefaultReaction() == null) {
            return null;
        }
        return new Emote(forumChannel.getDefaultReaction());
    }

    @NotNull
    public Class<? extends Emote> getReturnType() {
        return Emote.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "default forum emoji";
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        this.change(event, delta, mode, false);
    }

    public Class<?> @NotNull [] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{Emote.class};
        }
        return new Class[0];
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode, boolean complete) {
        Object action;
        ForumChannel channel = (ForumChannel)this.getExpr().getSingle(e);
        if (channel == null) {
            return;
        }
        switch (mode) {
            case SET: {
                if (!EasyElement.isValid(delta) || delta[0] == null) {
                    return;
                }
                Emote emote = (Emote)delta[0];
                action = channel.getManager().setDefaultReaction(emote.getEmoji());
                break;
            }
            case RESET: 
            case DELETE: {
                action = channel.getManager().setDefaultReaction(null);
                break;
            }
            default: {
                return;
            }
        }
        if (complete) {
            action.complete();
        } else {
            action.queue();
        }
    }

    static {
        DefaultEmoji.register(DefaultEmoji.class, Emote.class, (String)"default [forum] emoji", (String)"forumchannel");
    }
}

