/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.forums;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.dv8tion.jda.api.entities.channel.attribute.IPostContainer;
import net.dv8tion.jda.api.entities.channel.concrete.ForumChannel;
import net.itsthesky.disky.api.ReflectionUtils;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForumSortOrder
extends SimplePropertyExpression<ForumChannel, String>
implements IAsyncChangeableExpression {
    @Nullable
    public String convert(ForumChannel forumChannel) {
        return forumChannel.getDefaultSortOrder().name().toLowerCase();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "forum default sort order";
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        this.change(event, delta, mode, false);
    }

    public Class<?> @NotNull [] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return new Class[0];
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode, boolean complete) {
        Object action;
        ForumChannel channel = (ForumChannel)this.getExpr().getSingle(e);
        if (channel == null) {
            return;
        }
        switch (mode) {
            case SET: {
                if (!EasyElement.isValid(delta) || delta[0] == null) {
                    return;
                }
                String rawLayout = (String)delta[0];
                IPostContainer.SortOrder sortOrder = ReflectionUtils.parseEnum(IPostContainer.SortOrder.class, rawLayout);
                if (sortOrder == null) {
                    Skript.error((String)("The sort order named '" + rawLayout + "' doesn't exist!"));
                    return;
                }
                action = channel.getManager().setDefaultSortOrder(sortOrder);
                break;
            }
            case RESET: 
            case DELETE: {
                action = channel.getManager().setDefaultSortOrder(IPostContainer.SortOrder.RECENT_ACTIVITY);
                break;
            }
            default: {
                return;
            }
        }
        if (complete) {
            action.complete();
        } else {
            action.queue();
        }
    }

    static {
        ForumSortOrder.register(ForumSortOrder.class, String.class, (String)"[forum] [default] sort order", (String)"forumchannel");
    }
}

