/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.guilds;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Icon;
import net.itsthesky.disky.api.changers.ChangeablePropertyExpression;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuildBanner
extends ChangeablePropertyExpression<Guild, String> {
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return (Class[])CollectionUtils.array((Object[])new Class[0]);
    }

    @Override
    public void change(Event e, Object[] delta, Bot bot, Changer.ChangeMode mode) {
        Icon icon;
        InputStream iconStream;
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        Guild guild = EasyElement.parseSingle(this.getExpr(), e, null);
        String value = delta[0].toString();
        if (value == null || guild == null) {
            return;
        }
        guild = bot.getInstance().getGuildById(guild.getId());
        if (Utils.isURL(value)) {
            try {
                iconStream = new URL(value).openStream();
            }
            catch (IOException ex) {
                DiSkyRuntimeHandler.error(ex);
                return;
            }
        }
        File iconFile = new File(value);
        if (iconFile == null || !iconFile.exists()) {
            return;
        }
        try {
            iconStream = new FileInputStream(iconFile);
        }
        catch (FileNotFoundException ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        try {
            icon = Icon.from(iconStream);
        }
        catch (IOException ex) {
            DiSkyRuntimeHandler.error(ex);
            return;
        }
        guild.getManager().setBanner(icon).queue();
    }

    protected String @NotNull [] get(@NotNull Event e, Guild @NotNull [] source2) {
        return new String[]{source2[0].getBannerUrl()};
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "banner of " + this.getExpr().toString(e, debug);
    }

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    static {
        GuildBanner.register(GuildBanner.class, String.class, (String)"[discord] banner", (String)"guild");
    }
}

