/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.members;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.util.Date;
import java.util.TimeZone;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.elements.properties.members.MemberProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Member Join Date")
@Description(value={"Represent the skript's date of the member's join date.", "It cannot be changed.", "This is a specific element of the bot, so it can be used in the bots event."})
@Examples(value={"reply with member join date of event-member"})
public class MemberJoinDate
extends MemberProperty<Date> {
    @Nullable
    public Date convert(Member member) {
        return new Date(member.getTimeJoined().toInstant().toEpochMilli(), TimeZone.getTimeZone("GMT"));
    }

    @NotNull
    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    static {
        MemberJoinDate.register(MemberJoinDate.class, Date.class, "[member] join date");
    }
}

