/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.ScheduledEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Message/Event Jump URL")
@Description(value={"Get the jump URL of a specific message/scheduled event"})
@Examples(value={"jump url of event-message", "jump url of scheduled event with id \"000\""})
public class MessageJumpURL
extends SimplePropertyExpression<Object, String> {
    @NotNull
    protected String getPropertyName() {
        return "jump url";
    }

    @Nullable
    public String convert(Object entity) {
        if (entity instanceof Message) {
            return ((Message)entity).getJumpUrl();
        }
        return "https://discord.com/events/" + ((ScheduledEvent)entity).getGuild().getId() + "/" + ((ScheduledEvent)entity).getId();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    static {
        MessageJumpURL.register(MessageJumpURL.class, String.class, (String)"[discord] [message] [jump] url", (String)"message");
    }
}

