/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.messages;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.entities.Message;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Emotes")
@Description(value={"Get every mentioned emotes in a message.", "This will only return custom emote, and will therefore not include discord emotes."})
@Examples(value={"mentioned emotes of event-message"})
public class MessageMentionedEmotes
extends MultiplyPropertyExpression<Message, Emote> {
    @Override
    @NotNull
    public Class<? extends Emote> getReturnType() {
        return Emote.class;
    }

    @Override
    protected String getPropertyName() {
        return "mentioned emotes";
    }

    protected Emote[] convert(Message message2) {
        return (Emote[])message2.getMentions().getCustomEmojis().stream().map(Emote::new).toArray(Emote[]::new);
    }

    static {
        MessageMentionedEmotes.register(MessageMentionedEmotes.class, Emote.class, "[discord] [message] mentioned emote[s]", "message");
    }
}

