/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.polls;

import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.messages.MessagePoll;
import net.itsthesky.disky.api.emojis.Emote;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PollAnswerData {
    @NotNull
    public String answer;
    @Nullable
    public Emote emote;
    public int votes = 0;
    public boolean selfVote = false;

    public PollAnswerData(@NotNull String answer, @Nullable Emote emote) {
        this.answer = answer;
        this.emote = emote;
    }

    public PollAnswerData(@NotNull MessagePoll.Answer answer) {
        this.answer = answer.getText();
        this.emote = Emote.fromUnion(answer.getEmoji());
        this.votes = answer.getVotes();
        this.selfVote = answer.isSelfVoted();
    }

    @NotNull
    public String getAnswer() {
        return this.answer;
    }

    @Nullable
    public Emote getEmote() {
        return this.emote;
    }

    @Nullable
    public Emoji getJDAEmote() {
        return this.emote == null ? null : this.emote.getEmoji();
    }

    public boolean isValid() {
        return this.answer != null && !this.answer.isEmpty();
    }

    public String asString() {
        return this.answer + (String)(this.emote == null ? "" : " " + this.emote.getName());
    }

    public boolean isSelfVote() {
        return this.selfVote;
    }

    public int getVotes() {
        return this.votes;
    }
}

