/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.profile;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.managers.AccountManager;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.changers.IAsyncChangeableExpression;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Profile Banner")
@Description(value={"Get the profile banner URL. If the user doesn't have a custom banner, this will return none.", "Use the 'profile color' expression to get the color instead of the banner URL in that case!"})
public class ProfileBanner
extends SimplePropertyExpression<Object, String>
implements IAsyncChangeableExpression {
    private Node node;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.node = this.getParser().getNode();
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @NotNull
    protected String getPropertyName() {
        return "profile banner";
    }

    @Nullable
    public String convert(Object profile) {
        if (profile instanceof User.Profile) {
            return ((User.Profile)profile).getBannerUrl();
        }
        if (profile instanceof Bot) {
            DiSkyRuntimeHandler.error(new Exception("Cannot retrieve profile banner from a bot, retrieve its profile first."), this.node);
        }
        return null;
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?> @NotNull [] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{String.class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        this.change(event, delta, mode, false);
    }

    @Override
    public void changeAsync(Event e, Object[] delta, Changer.ChangeMode mode) {
        this.change(e, delta, mode, true);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode, boolean async) {
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        if (mode != Changer.ChangeMode.SET) {
            return;
        }
        String bannerInput = delta[0].toString();
        Icon banner = SkriptUtils.parseIcon(bannerInput);
        if (banner == null) {
            DiSkyRuntimeHandler.error(new Exception("Cannot parse the given banner input! Must be valid URL or file path."), this.node);
            return;
        }
        for (Object entity : this.getExpr().getArray(event)) {
            if (entity instanceof Bot) {
                AccountManager manager = ((Bot)entity).getInstance().getSelfUser().getManager();
                AccountManager action = manager.setBanner(banner);
                try {
                    if (async) {
                        action.complete();
                        continue;
                    }
                    action.queue();
                }
                catch (Exception ex) {
                    DiSkyRuntimeHandler.error(ex, this.node);
                }
                continue;
            }
            if (!(entity instanceof User)) continue;
            DiSkyRuntimeHandler.error(new Exception("Cannot change the profile banner of a user."), this.node);
        }
    }

    static {
        ProfileBanner.register(ProfileBanner.class, String.class, (String)"profile banner [ur(l|i)]", (String)"userprofile/bot");
    }
}

