/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.properties.tags;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.channel.forums.BaseForumTag;
import net.dv8tion.jda.api.entities.channel.forums.ForumTagData;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.skript.EasyElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="New Forum Tag")
@Description(value={"Create a new forum tag with a specific name & optional emoji.", "You can also specify if the tag is 'moderate' or not."})
@Examples(value={"new forum tag named \"solved\" with reaction \"white_check_mark\"", "new moderated forum tag named \"internal\""})
@Since(value={"4.4.4"})
public class NewTag
extends SimpleExpression<BaseForumTag> {
    private Expression<String> exprName;
    private Expression<Emote> exprEmoji;
    private boolean moderate;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.exprName = exprs[0];
        this.exprEmoji = exprs[1];
        this.moderate = matchedPattern == 1;
        return true;
    }

    protected BaseForumTag @NotNull [] get(@NotNull Event e) {
        String name = EasyElement.parseSingle(this.exprName, e);
        Emote emoji = EasyElement.parseSingle(this.exprEmoji, e);
        if (name == null) {
            return new BaseForumTag[0];
        }
        return new BaseForumTag[]{new ForumTagData(name).setModerated(this.moderate).setEmoji(emoji.getEmoji())};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends BaseForumTag> getReturnType() {
        return BaseForumTag.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "new forum tag named " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerExpression(NewTag.class, BaseForumTag.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"new [forum] tag [named] %string% [with %-emote%]", "new moderated [forum] tag [named] %string% [with %-emote%]"});
    }
}

