/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.LoopSection;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.ScriptFunction;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesMap;
import ch.njol.util.Kleenean;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.DiSkyRegistry;
import net.itsthesky.disky.elements.sections.handler.DiSkyRuntimeHandler;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.registration.SyntaxRegistry;

public class FindMemberSection
extends Section {
    @Nullable
    public static FindMemberSection instance;
    private Expression<Guild> exprGuild;
    private Expression<Object> exprResult;
    private Expression<Object> exprValue;
    private Trigger trigger;
    private boolean iterationResult = false;

    public boolean init(Expression<?>[] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult, @NotNull SectionNode sectionNode, @NotNull List<TriggerItem> triggerItems) {
        this.exprGuild = expressions[0];
        this.exprResult = expressions[1];
        this.exprValue = expressions[2];
        if (!Changer.ChangerUtils.acceptsChange(this.exprValue, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member.class}) || !Changer.ChangerUtils.acceptsChange(this.exprResult, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{Member[].class})) {
            return false;
        }
        AtomicBoolean delayed = new AtomicBoolean(false);
        Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
        instance = this;
        this.trigger = this.loadCode(sectionNode, "find members", afterLoading, this.getParser().getCurrentEvents());
        instance = null;
        if (delayed.get()) {
            Skript.error((String)"Delays can't be used within a 'find member' section.");
            return false;
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(@NotNull Event e) {
        if (this.trigger == null) {
            return null;
        }
        Guild guild = (Guild)this.exprGuild.getSingle(e);
        if (guild == null) {
            return this.getNext();
        }
        this.debug(e, true);
        Delay.addDelayedEvent((Event)e);
        VariablesMap localVars = Variables.removeLocals((Event)e);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DiSky.getInstance(), () -> {
            if (localVars != null) {
                Variables.setLocalVariables((Event)e, (Object)localVars);
            }
            try {
                List<Member> members = guild.findMembers(member -> {
                    this.iterationResult = false;
                    this.exprValue.change(e, (Object[])new Member[]{member}, Changer.ChangeMode.SET);
                    TriggerItem.walk((TriggerItem)this.trigger, (Event)e);
                    return this.iterationResult;
                }).get();
                this.exprResult.change(e, (Object[])members.toArray(new Member[0]), Changer.ChangeMode.SET);
            }
            catch (Exception ex) {
                DiSkyRuntimeHandler.error(ex);
            }
            if (this.getNext() != null) {
                Bukkit.getScheduler().runTask((Plugin)Skript.getInstance(), () -> {
                    Trigger trigger;
                    Object timing = null;
                    if (SkriptTimings.enabled() && (trigger = this.getTrigger()) != null) {
                        timing = SkriptTimings.start((String)trigger.getDebugLabel());
                    }
                    TriggerItem.walk((TriggerItem)this.getNext(), (Event)e);
                    Variables.removeLocals((Event)e);
                    SkriptTimings.stop((Object)timing);
                });
            } else {
                Variables.removeLocals((Event)e);
            }
        });
        return null;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "find members in guild " + this.exprGuild.toString(event, debug) + " and store them in " + this.exprResult.toString(event, debug) + " with filter " + this.exprValue.toString(event, debug);
    }

    static {
        Skript.registerSection(FindMemberSection.class, (String[])new String[]{"find [the] [discord] member[s] (in|from) [guild] %guild% and store (them|the members) in %~objects% with filter var[iable] %~objects%"});
        if (DiSkyRegistry.unregisterElement(SyntaxRegistry.EXPRESSION, ch.njol.skript.effects.EffReturn.class)) {
            DiSky.debug("Unregistered the original 'permissions' expression, to replace it with a new one.");
        } else {
            Skript.error((String)"DiSky were unable to unregister the original 'permissions' expression, please report this error to the developer.");
        }
        Skript.registerEffect(EffReturn.class, (String[])new String[]{"return %objects%"});
    }

    public static class EffReturn
    extends Effect {
        private ScriptFunction<?> function;
        private Expression<?> value;
        @Nullable
        private FindMemberSection section;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
            Expression convertedExpr;
            if (instance != null) {
                this.section = instance;
                this.value = exprs[0];
                return true;
            }
            ScriptFunction f = Functions.currentFunction;
            if (f == null) {
                Skript.error((String)"The return statement can only be used in a function");
                return false;
            }
            if (!isDelayed.isFalse()) {
                Skript.error((String)"A return statement after a delay is useless, as the calling trigger will resume when the delay starts (and won't get any returned value)");
                return false;
            }
            this.function = f;
            ClassInfo returnType = this.function.getReturnType();
            if (returnType == null) {
                Skript.error((String)"This function doesn't return any value. Please use 'stop' or 'exit' if you want to stop the function.");
                return false;
            }
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                convertedExpr = exprs[0].getConvertedExpression(new Class[]{returnType.getC()});
                if (convertedExpr == null) {
                    log.printErrors("This function is declared to return " + returnType.getName().withIndefiniteArticle() + ", but " + exprs[0].toString(null, false) + " is not of that type.");
                    boolean bl = false;
                    return bl;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
            if (f.isSingle() && !convertedExpr.isSingle()) {
                Skript.error((String)("This function is defined to only return a single " + returnType.toString() + ", but this return statement can return multiple values."));
                return false;
            }
            this.value = convertedExpr;
            return true;
        }

        @Nullable
        protected TriggerItem walk(Event event) {
            this.debug(event, false);
            if (this.section != null) {
                try {
                    this.section.iterationResult = this.value.getSingle(event) != null && Boolean.TRUE.equals(this.value.getSingle(event));
                }
                catch (Exception e) {
                    Expression converted = this.value.getConvertedExpression(new Class[]{Boolean.class});
                    if (converted == null) {
                        Skript.error((String)("Cannot convert the value to a boolean: " + this.value.toString(event, false)));
                        return null;
                    }
                    this.section.iterationResult = converted.getSingle(event) != null && Boolean.TRUE.equals(converted.getSingle(event));
                }
                return null;
            }
            if (event instanceof FunctionEvent) {
                this.function.setReturnValue(this.value.getArray(event));
            } else assert (false) : event;
            for (TriggerSection parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof LoopSection)) continue;
                ((LoopSection)parent).exit(event);
            }
            return null;
        }

        protected void execute(Event event) {
            assert (false);
        }

        public String toString(@Nullable Event event, boolean debug) {
            return "return " + this.value.toString(event, debug);
        }
    }
}

