/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.automod;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import net.dv8tion.jda.api.entities.automod.AutoModResponse;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.sections.automod.CreateAutoMod;
import net.itsthesky.disky.managers.wrappers.AutoModRuleBuilder;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class AutomodResponse
extends MultiplyPropertyExpression<AutoModRuleBuilder, AutoModResponse> {
    @Override
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentSection(CreateAutoMod.class)) {
            Skript.error((String)"You can only use the 'automod rule responses' expression inside a 'create auto mod rule' section");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD) {
            return new Class[]{AutoModResponse.class, AutoModResponse[].class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        AutoModRuleBuilder builder = EasyElement.parseSingle(this.getExpr(), e, null);
        if (builder == null) {
            return;
        }
        ArrayList<AutoModResponse> responses = new ArrayList<AutoModResponse>();
        for (Object response : delta) {
            responses.add((AutoModResponse)response);
        }
        if (mode == Changer.ChangeMode.ADD) {
            builder.addResponses(responses.toArray(new AutoModResponse[0]));
        } else {
            Skript.warning((String)"You can't remove a response from an automod rule!");
        }
    }

    @Override
    @NotNull
    public Class<? extends AutoModResponse> getReturnType() {
        return AutoModResponse.class;
    }

    @Override
    protected String getPropertyName() {
        return "attachments";
    }

    protected AutoModResponse[] convert(AutoModRuleBuilder builder) {
        return new AutoModResponse[0];
    }

    static {
        AutomodResponse.register(AutomodResponse.class, AutoModResponse.class, "(response|action)[s]", "automodrule");
    }
}

