/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.automod;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.entities.automod.build.AutoModRuleData;
import net.dv8tion.jda.api.entities.automod.build.TriggerConfig;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.automod.FilterType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewRuleType
extends SimpleExpression<AutoModRuleData> {
    private Expression<FilterType> exprType;
    private Expression<Object> exprFilter;
    private Expression<String> exprName;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprType = exprs[0];
        this.exprFilter = exprs[1];
        this.exprName = exprs[2];
        return true;
    }

    protected AutoModRuleData @NotNull [] get(@NotNull Event e) {
        String name;
        FilterType filterType = EasyElement.parseSingle(this.exprType, e);
        Object[] filters = EasyElement.parseList(this.exprFilter, e, null);
        if (EasyElement.anyNull((Object)this, new Object[]{filters, name = EasyElement.parseSingle(this.exprName, e), filterType})) {
            return new AutoModRuleData[0];
        }
        if (filterType.equals((Object)FilterType.MENTION) && filters.length != 0 && !(filters[0] instanceof Number)) {
            Skript.error((String)"The filter type 'mention' need a number as filter!");
            return new AutoModRuleData[0];
        }
        for (Object filter : filters) {
            if (filter instanceof String) continue;
            Skript.error((String)("The filter type '" + filterType.name() + "' need a text/string as filter!"));
            return new AutoModRuleData[0];
        }
        switch (filterType) {
            case MENTION: {
                Number number = (Number)filters[0];
                return new AutoModRuleData[]{AutoModRuleData.onMessage(name, TriggerConfig.mentionSpam(number.intValue()))};
            }
            case KEYWORD: {
                String[] keywords = new String[filters.length];
                for (int i = 0; i < filters.length; ++i) {
                    keywords[i] = (String)filters[i];
                }
                return new AutoModRuleData[]{AutoModRuleData.onMessage(name, TriggerConfig.keywordFilter(keywords))};
            }
            case PATTERN: {
                String[] patterns = new String[filters.length];
                for (int i = 0; i < filters.length; ++i) {
                    patterns[i] = (String)filters[i];
                }
                return new AutoModRuleData[]{AutoModRuleData.onMessage(name, TriggerConfig.patternFilter(patterns))};
            }
        }
        return new AutoModRuleData[0];
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends AutoModRuleData> getReturnType() {
        return AutoModRuleData.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "message with " + this.exprType.toString(e, debug) + " filter " + this.exprFilter.toString(e, debug) + " with name " + this.exprName.toString(e, debug);
    }

    static {
        Skript.registerExpression(NewRuleType.class, AutoModRuleData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"message with [the] %filtertype% filter %objects% (with name|named) %string%"});
    }
}

