/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.components;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import net.dv8tion.jda.api.components.ActionComponent;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.components.textinput.TextInput;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Row Builder Components")
@Description(value={"Components of a row builder", "See also: 'Create (rich) Message'"})
public class RowComponents
extends MultiplyPropertyExpression<ComponentRow, Object> {
    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (EasyElement.equalAny(mode, Changer.ChangeMode.SET, Changer.ChangeMode.ADD)) {
            return new Class[]{SelectMenu.Builder.class, Button.class, Button[].class, TextInput.Builder.class, TextInput.Builder[].class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        ComponentRow row2 = (ComponentRow)EasyElement.parseSingle(this.getExpr(), e);
        if (row2 == null) {
            return;
        }
        for (Object comp : delta) {
            if (comp instanceof SelectMenu.Builder) {
                row2.setMenu((SelectMenu)((SelectMenu.Builder)comp).build());
                continue;
            }
            if (comp instanceof Button) {
                row2.add((Button)comp);
                continue;
            }
            if (!(comp instanceof TextInput.Builder)) continue;
            row2.setInput(((TextInput.Builder)comp).build());
        }
    }

    @Override
    @NotNull
    public Class<? extends ActionComponent> getReturnType() {
        return ActionComponent.class;
    }

    @Override
    protected String getPropertyName() {
        return "components";
    }

    protected ActionComponent[] convert(ComponentRow row2) {
        return row2.asComponents().toArray(new ActionComponent[0]);
    }

    static {
        RowComponents.register(RowComponents.class, Object.class, "component[s]", "row");
    }
}

