/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.handler;

import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.JDAUtils;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.core.UpdateCheckerTask;
import net.itsthesky.disky.core.Utils;
import net.itsthesky.disky.managers.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiSkyRuntimeHandler {
    private static final List<Exception> errors = new ArrayList<Exception>();
    private static boolean isHandling = false;
    private static final List<String> QUEUED_MESSAGES = new ArrayList<String>();

    public static void start() {
        errors.clear();
        isHandling = true;
    }

    public static void error(Exception error) {
        DiSkyRuntimeHandler.error(error, null);
    }

    public static void error(Exception error, Node node) {
        DiSkyRuntimeHandler.error(error, node, true);
    }

    public static void error(Exception error, Node node, boolean shouldDisplayStacktraceFinal) {
        Exception internalException = node != null ? new NodeException(error, node) : error;
        SkriptUtils.sync(() -> {
            DiSkyRuntimeErrorEvent event = new DiSkyRuntimeErrorEvent(internalException);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            boolean shouldDisplayStacktrace = shouldDisplayStacktraceFinal;
            if (!shouldDisplayStacktrace && ConfigManager.get("debug", false).booleanValue()) {
                shouldDisplayStacktrace = true;
            }
            if (!isHandling) {
                DiSkyRuntimeHandler.printException(node, error, shouldDisplayStacktrace);
                return;
            }
            errors.add(internalException);
        });
    }

    public static List<Exception> end() {
        isHandling = false;
        ArrayList<Exception> errors = new ArrayList<Exception>(DiSkyRuntimeHandler.errors);
        DiSkyRuntimeHandler.errors.clear();
        return errors;
    }

    public static void exprNotSet(Node node, Expression<?> ... exprs) {
        if (exprs.length == 1) {
            Expression<?> expr = exprs[0];
            if (expr == null) {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("The given expression is not set! (None)"), node, false);
            } else {
                DiSkyRuntimeHandler.error(new IllegalArgumentException("The value of the expression '" + String.valueOf(expr) + "' is not set! (None)"), node, false);
            }
        } else {
            StringBuilder builder = new StringBuilder("The value of the following expressions are not set:\n");
            for (Expression<?> expr : exprs) {
                builder.append(" - ").append(expr).append("\n");
            }
            DiSkyRuntimeHandler.error(new IllegalArgumentException(builder.toString()), node, false);
        }
    }

    public static boolean checkSet(Node node, Object ... data) {
        ArrayList<Expression> unSet = new ArrayList<Expression>();
        for (int i = 0; i < data.length; i += 2) {
            if (data[i] != null) continue;
            unSet.add((Expression)data[i + 1]);
        }
        if (!unSet.isEmpty()) {
            DiSkyRuntimeHandler.exprNotSet(node, unSet.toArray(new Expression[0]));
            return false;
        }
        return true;
    }

    public static void notSnowflake(Node node, String id) {
        DiSkyRuntimeHandler.error(new IllegalArgumentException("The given ID '" + id + "' is not a valid identifier (snowflake)!"), node, false);
    }

    public static boolean checkSnowflake(Node node, String id) {
        if (!JDAUtils.isSnowflake(id)) {
            DiSkyRuntimeHandler.notSnowflake(node, id);
            return false;
        }
        return true;
    }

    public static boolean validateAsync(boolean async, Node node) {
        if (async) {
            return true;
        }
        String prefixedNode = "await " + node.getKey();
        DiSkyRuntimeHandler.error(new IllegalStateException("This effect must be executed asynchronously! Prefix your line with 'await':\n    " + prefixedNode), node, false);
        return false;
    }

    private static void send(String message2) {
        QUEUED_MESSAGES.add(Utils.colored(message2));
    }

    private static void sendAll() {
        Bukkit.getConsoleSender().sendMessage(QUEUED_MESSAGES.toArray(new String[0]));
        QUEUED_MESSAGES.clear();
    }

    private static void printException(@Nullable Node node, @Nullable Exception exception, boolean displayStacktrace) {
        if (exception == null) {
            return;
        }
        QUEUED_MESSAGES.clear();
        DiSkyRuntimeHandler.send("&4[&c!&4] &c");
        DiSkyRuntimeHandler.send("&4[&c!&4] &4DiSky Internal Error (version: " + DiSky.getInstance().getDescription().getVersion() + ")");
        DiSkyRuntimeHandler.send("&4[&c!&4] &4Error type: &c" + exception.getClass().getSimpleName());
        if (UpdateCheckerTask.STATE == UpdateCheckerTask.VersionState.OUTDATED) {
            DiSkyRuntimeHandler.send("&4[&c!&4] &c");
            DiSkyRuntimeHandler.send("&4[&c!&4] &4You are using an outdated version of DiSky, please update to the latest version.");
            DiSkyRuntimeHandler.send("&4[&c!&4] &4You can download the latest version here: https://modrinth.com/plugin/disky");
        }
        DiSkyRuntimeHandler.send("&4[&c!&4] &c");
        DiSkyRuntimeHandler.send("&4[&c!&4] &e- - - - - - - - - - - - - - - - - - - - - - - - -");
        for (String line : exception.getMessage().split("\n")) {
            DiSkyRuntimeHandler.send("&4[&c!&4] &e" + line);
        }
        if (displayStacktrace) {
            DiSkyRuntimeHandler.send("&4[&c!&4] &e");
            for (StackTraceElement element : exception.getStackTrace()) {
                DiSkyRuntimeHandler.send("&4[&c!&4] &6" + element.toString());
            }
        }
        DiSkyRuntimeHandler.send("&4[&c!&4] &e- - - - - - - - - - - - - - - - - - - - - - - - -");
        if (node != null) {
            DiSkyRuntimeHandler.send("&4[&c!&4] &c");
            DiSkyRuntimeHandler.send("&4[&c!&4] &4Error occurred in the following node:");
            DiSkyRuntimeHandler.send("&4[&c!&4] &c");
            DiSkyRuntimeHandler.send("&4[&c!&4] &7" + node.getKey() + " &6(" + node.getConfig().getFileName() + ", line " + node.getLine() + ")");
            DiSkyRuntimeHandler.send("&4[&c!&4] &c");
        }
        DiSkyRuntimeHandler.send("&4[&c!&4] &c");
        DiSkyRuntimeHandler.sendAll();
    }

    public static class NodeException
    extends Exception {
        private final Node node;

        public NodeException(Exception exception, Node node) {
            super(exception);
            this.node = node;
        }

        @Generated
        public Node getNode() {
            return this.node;
        }
    }

    public static class DiSkyRuntimeErrorEvent
    extends Event
    implements Cancellable {
        private final Exception exception;
        private boolean cancelled = false;
        private static final HandlerList handlers = new HandlerList();

        public DiSkyRuntimeErrorEvent(Exception exception) {
            this.exception = exception;
        }

        @Nullable
        public Node getNode() {
            Exception exception = this.exception;
            if (exception instanceof NodeException) {
                NodeException nodeException = (NodeException)exception;
                return nodeException.getNode();
            }
            return null;
        }

        public String toString() {
            return "DiSkyRuntimeErrorEvent{exception=" + String.valueOf(this.exception) + ", node=" + String.valueOf(this.getNode()) + "}";
        }

        @NotNull
        public HandlerList getHandlers() {
            return handlers;
        }

        public static HandlerList getHandlerList() {
            return handlers;
        }

        @Generated
        public Exception getException() {
            return this.exception;
        }

        @Generated
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Generated
        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }
}

