/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.message;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.sections.message.CreateMessage;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Builder Embeds")
@Description(value={"Embeds of a message builder", "See also: 'Create (rich) Message'"})
public class MessageEmbeds
extends MultiplyPropertyExpression<MessageCreateBuilder, EmbedBuilder> {
    @Override
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentSection(CreateMessage.class)) {
            Skript.error((String)"You can only use the 'message embeds' expression inside a 'create message' section");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return new Class[]{EmbedBuilder.class, EmbedBuilder[].class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        MessageCreateBuilder builder = EasyElement.parseSingle(this.getExpr(), e, null);
        EmbedBuilder[] builders = (EmbedBuilder[])delta;
        if (builder == null || builders.length < 1) {
            return;
        }
        List embeds = Stream.of(builders).map(EmbedBuilder::build).collect(Collectors.toList());
        switch (mode) {
            case ADD: {
                builder.addEmbeds((Collection)embeds);
                return;
            }
            case SET: {
                builder.setEmbeds((Collection)embeds);
            }
        }
    }

    @Override
    @NotNull
    public Class<? extends EmbedBuilder> getReturnType() {
        return EmbedBuilder.class;
    }

    @Override
    protected String getPropertyName() {
        return "embeds";
    }

    protected EmbedBuilder[] convert(MessageCreateBuilder messageCreateBuilder) {
        return (EmbedBuilder[])messageCreateBuilder.getEmbeds().stream().map(EmbedBuilder::new).toArray(EmbedBuilder[]::new);
    }

    static {
        MessageEmbeds.register(MessageEmbeds.class, EmbedBuilder.class, "embed[s]", "messagecreatebuilder");
    }
}

