/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.message;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import java.util.ArrayList;
import java.util.LinkedList;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.ModalTopLevelComponent;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.actionrow.ActionRowChildComponent;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.modals.Modal;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.api.skript.MultiplyPropertyExpression;
import net.itsthesky.disky.elements.components.core.ComponentRow;
import net.itsthesky.disky.elements.componentsv2.base.sub.TextDisplayBuilder;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Message Builder Component Rows")
@Description(value={"Component rows of a message builder", "See also: 'Creator Components Row'"})
public class MessageModalRows
extends MultiplyPropertyExpression<Object, Object> {
    public Class<?> @NotNull [] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD) {
            return new Class[]{ComponentRow.class, ComponentRow[].class, Button.class, Button[].class, SelectMenu.Builder.class, SelectMenu.Builder[].class, Modal.Builder.class, Modal.Builder[].class, ModalTopLevelComponent.class, ModalTopLevelComponent[].class, TextDisplayBuilder.class, TextDisplayBuilder[].class};
        }
        return new Class[0];
    }

    public void change(@NotNull Event e, @NotNull Object[] delta, @NotNull Changer.ChangeMode mode) {
        if (!EasyElement.isValid(delta)) {
            return;
        }
        Object builder = EasyElement.parseSingle(this.getExpr(), e, null);
        if (builder == null) {
            return;
        }
        if (builder instanceof MessageCreateBuilder) {
            MessageCreateBuilder messageBuilder = builder;
            LinkedList<ActionRow> rows = new LinkedList<ActionRow>();
            for (Object obj : delta) {
                if (obj instanceof Button) {
                    rows.add(ActionRow.of((Button)obj, new ActionRowChildComponent[0]));
                    continue;
                }
                if (obj instanceof ComponentRow) {
                    rows.add(((ComponentRow)obj).asActionRow());
                    continue;
                }
                if (!(obj instanceof SelectMenu.Builder)) continue;
                rows.add(ActionRow.of(((SelectMenu.Builder)obj).build(), new ActionRowChildComponent[0]));
            }
            messageBuilder.addComponents(rows);
        } else if (builder instanceof Modal.Builder) {
            Modal.Builder modalBuilder = builder;
            ArrayList<ModalTopLevelComponent> components = new ArrayList<ModalTopLevelComponent>();
            for (Object obj : delta) {
                if (obj instanceof ModalTopLevelComponent) {
                    components.add((ModalTopLevelComponent)obj);
                    continue;
                }
                if (!(obj instanceof TextDisplayBuilder)) continue;
                components.add(((TextDisplayBuilder)obj).build());
            }
            modalBuilder.addComponents(components);
        }
    }

    @Override
    @NotNull
    public Class<?> getReturnType() {
        return Object.class;
    }

    @Override
    protected String getPropertyName() {
        return "rows";
    }

    @Override
    protected Object[] convert(Object object) {
        if (object instanceof MessageCreateBuilder) {
            return ((MessageCreateBuilder)object).getComponents().toArray(new Component[0]);
        }
        if (object instanceof Modal.Builder) {
            return ((Modal.Builder)object).getComponents().toArray(new Component[0]);
        }
        return new Object[0];
    }

    static {
        MessageModalRows.register(MessageModalRows.class, Object.class, "[component[s]] row[s]", "messagecreatebuilder/modal");
    }
}

