/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.welcome;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import net.dv8tion.jda.api.entities.GuildWelcomeScreen;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.StandardGuildChannel;
import net.dv8tion.jda.api.managers.GuildWelcomeScreenManager;
import net.itsthesky.disky.api.emojis.Emote;
import net.itsthesky.disky.api.skript.EasyElement;
import net.itsthesky.disky.elements.sections.welcome.ScreenElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Add Welcome Screen Channel")
@Description(value={"Add a channel to the welcome screen of a guild.", "Can only be used in a 'modify welcome screen' section."})
@Examples(value={"discord command setup <guild>:\n    trigger:\n        modify welcome screen of arg-1:\n            change the screen description to \"Welcome to the server! Please read the rules and get roles before chatting.\"\n            add channel with id \"937001799896956991\" named \"Read our rules\" with reaction \"\ud83d\udcdc\" to the screen\n            add channel with id \"952199041335316520\" named \"Get roles\" with reaction \"\ud83c\udf9f\ufe0f\" to the screen"})
@Since(value={"4.10.0"})
public class AddScreenChannel
extends Effect
implements ScreenElement {
    private Expression<Channel> exprChannel;
    private Expression<String> exprName;
    private Expression<Emote> exprEmoji;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprChannel = exprs[0];
        this.exprName = exprs[1];
        this.exprEmoji = exprs[2];
        return true;
    }

    @Override
    @NotNull
    public GuildWelcomeScreenManager apply(@NotNull GuildWelcomeScreenManager manager, @NotNull Event event) {
        Channel channel = EasyElement.parseSingle(this.exprChannel, event);
        String name = EasyElement.parseSingle(this.exprName, event);
        Emote emoji = EasyElement.parseSingle(this.exprEmoji, event);
        if (name == null || !(channel instanceof StandardGuildChannel)) {
            return manager;
        }
        ArrayList<GuildWelcomeScreen.Channel> current = new ArrayList<GuildWelcomeScreen.Channel>(manager.getWelcomeChannels());
        if (current.size() >= 5) {
            return manager;
        }
        if (emoji == null) {
            current.add(GuildWelcomeScreen.Channel.of((StandardGuildChannel)channel, name));
        } else {
            current.add(GuildWelcomeScreen.Channel.of((StandardGuildChannel)channel, name, emoji.getEmoji()));
        }
        return manager.setWelcomeChannels(current);
    }

    protected void execute(@NotNull Event e) {
        throw new UnsupportedOperationException("This effect is not supposed to be 'walked'!");
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "add channel " + this.exprChannel.toString(e, debug) + " named " + this.exprName.toString(e, debug) + " with emoji " + this.exprEmoji.toString(e, debug);
    }

    static {
        Skript.registerEffect(AddScreenChannel.class, (String[])new String[]{"add [the] [channel] %channel% (named|with name) %string% [with [emoji] %-emote%] [to [the] [welcome] screen]"});
    }
}

