/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.sections.welcome;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import net.dv8tion.jda.api.managers.GuildWelcomeScreenManager;
import net.itsthesky.disky.elements.sections.welcome.ScreenElement;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Welcome Screen Description")
@Description(value={"Change the description of the welcome screen.", "Can only be used in a 'modify welcome screen' section."})
@Examples(value={"discord command setup <guild>:\n    trigger:\n        modify welcome screen of arg-1:\n            change the screen description to \"Welcome to the server! Please read the rules and get roles before chatting.\"\n            add channel with id \"937001799896956991\" named \"Read our rules\" with reaction \"\ud83d\udcdc\" to the screen\n            add channel with id \"952199041335316520\" named \"Get roles\" with reaction \"\ud83c\udf9f\ufe0f\" to the screen"})
@Since(value={"4.10.0"})
public class ScreenDescription
extends Effect
implements ScreenElement {
    private Expression<String> exprDescription;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.exprDescription = exprs[0];
        return true;
    }

    @Override
    @NotNull
    public GuildWelcomeScreenManager apply(@NotNull GuildWelcomeScreenManager manager, @NotNull Event event) {
        String description = (String)this.exprDescription.getSingle(event);
        if (description == null) {
            return manager;
        }
        return manager.setDescription(description);
    }

    protected void execute(@NotNull Event e) {
        throw new UnsupportedOperationException("This effect is not supposed to be 'walked'!");
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "change welcome screen description to " + this.exprDescription.toString(e, debug);
    }

    static {
        Skript.registerEffect(ScreenDescription.class, (String[])new String[]{"change [the] [welcome] screen description to %string%", "change [the] description of [the] [welcome] screen to %string%"});
    }
}

