/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash;

import ch.njol.skript.lang.Trigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.events.guild.GuildReadyEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.events.rework.CommandEvents;
import net.itsthesky.disky.elements.events.rework.custom.SlashCooldownEvent;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import net.itsthesky.disky.elements.structures.slash.models.CommandGroup;
import net.itsthesky.disky.elements.structures.slash.models.CommandType;
import net.itsthesky.disky.elements.structures.slash.models.ParsedArgument;
import net.itsthesky.disky.elements.structures.slash.models.ParsedCommand;
import net.itsthesky.disky.elements.structures.slash.models.RegisteredGroup;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SlashManager
extends ListenerAdapter {
    private static final Map<Bot, SlashManager> MANAGERS = new HashMap<Bot, SlashManager>();
    private final Map<String, List<Runnable>> waitingGuildCommands = new HashMap<String, List<Runnable>>();
    private final Map<String, AtomicInteger> guildRetryAttempts = new ConcurrentHashMap<String, AtomicInteger>();
    private final Set<String> readyGuilds = new HashSet<String>();
    private final List<Runnable> waitingGlobalCommands = new ArrayList<Runnable>();
    private final List<RegisteredGroup> registeredGroups = new ArrayList<RegisteredGroup>();
    private final Map<String, CommandGroup> commandGroups = new ConcurrentHashMap<String, CommandGroup>();
    private final Bot bot;
    private boolean readyGlobal = false;
    private static final int MAX_RETRY_ATTEMPTS = 5;
    private static final long BASE_RETRY_DELAY_MS = 1000L;
    private static final ScheduledExecutorService retryScheduler = Executors.newScheduledThreadPool(2);

    public static SlashManager getManager(Bot bot) {
        return MANAGERS.computeIfAbsent(bot, SlashManager::new);
    }

    public static void shutdownAll() {
        MANAGERS.values().forEach(SlashManager::shutdown);
        MANAGERS.clear();
        retryScheduler.shutdown();
    }

    private SlashManager(Bot bot) {
        this.bot = bot;
        DiSky.debug("Created SlashManager for bot " + bot.getName());
        this.bot.getInstance().addEventListener(this);
    }

    public void registerCommand(ParsedCommand command) {
        String[] parts = command.getName().split(" ");
        String baseCommandName = parts[0];
        CommandGroup group = this.commandGroups.compute(baseCommandName, (name, existingGroup) -> {
            CommandType type = parts.length == 1 ? CommandType.SINGLE : CommandType.GROUP;
            return existingGroup != null ? existingGroup : new CommandGroup((String)name, type);
        });
        group.addSubCommand(command);
        if (command.getGuilds().isEmpty()) {
            this.registerGlobalCommandGroup(group);
        } else {
            this.handleGuildSpecificCommandGroup(group, command.getGuilds());
        }
    }

    private void registerGlobalCommandGroup(CommandGroup group) {
        DiSky.debug("Registering command group " + group.getName() + " globally");
        Runnable registrationTask = () -> {
            SlashCommandData commandData = group.buildCommandData();
            this.bot.getInstance().upsertCommand(commandData).queue(cmd -> this.registerCommandGroupSuccess(group, (Command)cmd, null), error -> DiSky.debug("Failed to register command group " + group.getName() + ": " + error.getMessage()));
        };
        if (this.readyGlobal) {
            registrationTask.run();
        } else {
            this.waitingGlobalCommands.add(registrationTask);
            DiSky.debug("Bot " + this.bot.getName() + " is not ready yet, waiting for ready event to register command group");
        }
    }

    private void handleGuildSpecificCommandGroup(CommandGroup group, List<String> guildIds) {
        for (String guildId : guildIds) {
            Runnable registrationTask = () -> {
                Guild guild = this.bot.getInstance().getGuildById(guildId);
                if (guild == null) {
                    DiSky.debug("Guild " + guildId + " not found, skipping command group registration");
                    return;
                }
                SlashCommandData commandData = group.buildCommandData();
                guild.upsertCommand(commandData).queue(cmd -> this.registerCommandGroupSuccess(group, (Command)cmd, guildId), error -> DiSky.debug("Failed to register command group " + group.getName() + " in guild " + guildId + ": " + error.getMessage()));
            };
            if (this.isGuildReady(guildId)) {
                registrationTask.run();
                continue;
            }
            this.waitingGuildCommands.computeIfAbsent(guildId, k -> new ArrayList()).add(registrationTask);
            DiSky.debug("Guild " + guildId + " is not ready yet, waiting for ready event to register command group");
            this.scheduleGuildRegistrationRetry(guildId);
        }
    }

    private void registerCommandGroupSuccess(CommandGroup group, Command cmd, @Nullable String guildId) {
        this.registeredGroups.removeIf(rg -> rg.getCommandGroup().getName().equals(group.getName()) && Objects.equals(rg.getGuildId(), guildId));
        RegisteredGroup registeredGroup = new RegisteredGroup(group, cmd.getIdLong(), this.bot.getName(), guildId);
        this.registeredGroups.add(registeredGroup);
        DiSky.debug("Successfully registered command group " + group.getName() + (String)(guildId != null ? " in guild " + guildId : " globally"));
    }

    public RegisteredGroup findGroup(String commandName, String guildId) {
        String baseName = commandName.split(" ")[0];
        return this.registeredGroups.stream().filter(group -> group.getCommandGroup().getName().equals(baseName) && Objects.equals(group.getGuildId(), guildId)).findFirst().orElse(null);
    }

    public RegisteredGroup findGroup(String commandName) {
        String baseName = commandName.split(" ")[0];
        return this.registeredGroups.stream().filter(group -> group.getCommandGroup().getName().equals(baseName) && group.getGuildId() == null).findFirst().orElse(null);
    }

    @Override
    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        RegisteredGroup group;
        StringBuilder fullCommandName = new StringBuilder(event.getName());
        if (event.getSubcommandGroup() != null) {
            fullCommandName.append(" ").append(event.getSubcommandGroup());
        }
        if (event.getSubcommandName() != null) {
            fullCommandName.append(" ").append(event.getSubcommandName());
        }
        String commandString = fullCommandName.toString();
        RegisteredGroup registeredGroup = group = event.isGlobalCommand() ? this.findGroup(event.getName()) : this.findGroup(event.getName(), Objects.requireNonNull(event.getGuild()).getId());
        if (group == null) {
            DiSky.debug("Received unregistered command '" + String.valueOf(fullCommandName) + "' for execution (global: " + event.isGlobalCommand() + ")");
            return;
        }
        ParsedCommand command = group.findCommand(commandString);
        if (command == null) {
            DiSky.debug("Command '" + commandString + "' not found in group " + group.getCommandGroup().getName());
            return;
        }
        this.tryExecute(group, command, event);
    }

    @Override
    public void onCommandAutoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        RegisteredGroup group;
        StringBuilder fullCommandName = new StringBuilder(event.getName());
        if (event.getSubcommandGroup() != null) {
            fullCommandName.append(" ").append(event.getSubcommandGroup());
        }
        if (event.getSubcommandName() != null) {
            fullCommandName.append(" ").append(event.getSubcommandName());
        }
        String commandString = fullCommandName.toString();
        RegisteredGroup registeredGroup = group = event.isGlobalCommand() ? this.findGroup(event.getName()) : this.findGroup(event.getName(), Objects.requireNonNull(event.getGuild()).getId());
        if (group == null) {
            DiSky.debug("Received unregistered command '" + event.getName() + "' for auto-completion");
            return;
        }
        ParsedCommand command = group.findCommand(commandString);
        if (command == null) {
            DiSky.debug("Command '" + commandString + "' not found in group " + group.getCommandGroup().getName());
            return;
        }
        this.handleAutoComplete(command, event);
    }

    @Override
    public void onReady(@NotNull ReadyEvent event) {
        this.readyGlobal = true;
        DiSky.debug("Bot " + this.bot.getName() + " is ready, registering commands (" + this.waitingGlobalCommands.size() + ")");
        this.waitingGlobalCommands.forEach(Runnable::run);
        this.waitingGlobalCommands.clear();
    }

    @Override
    public void onGuildReady(@NotNull GuildReadyEvent event) {
        String guildId = event.getGuild().getId();
        this.processGuildReady(guildId);
    }

    private boolean isGuildReady(String guildId) {
        if (this.readyGuilds.contains(guildId)) {
            return true;
        }
        Guild guild = this.bot.getInstance().getGuildById(guildId);
        if (guild != null) {
            this.readyGuilds.add(guildId);
            DiSky.debug("Guild " + guildId + " was ready but not in cache, adding to ready set");
            return true;
        }
        return false;
    }

    private void processGuildReady(String guildId) {
        if (!this.waitingGuildCommands.containsKey(guildId)) {
            this.readyGuilds.add(guildId);
            return;
        }
        this.readyGuilds.add(guildId);
        this.guildRetryAttempts.remove(guildId);
        List<Runnable> tasks = this.waitingGuildCommands.remove(guildId);
        DiSky.debug("Guild " + guildId + " is ready, registering commands (" + tasks.size() + ")");
        tasks.forEach(Runnable::run);
    }

    private void scheduleGuildRegistrationRetry(String guildId) {
        AtomicInteger attempts = this.guildRetryAttempts.computeIfAbsent(guildId, k -> new AtomicInteger(0));
        int currentAttempt = attempts.incrementAndGet();
        if (currentAttempt >= 5) {
            DiSky.debug("Max retry attempts (5) reached for guild " + guildId + ", giving up");
            return;
        }
        long delay = 1000L * (1L << currentAttempt - 1);
        DiSky.debug("Scheduling retry attempt " + currentAttempt + " for guild " + guildId + " in " + delay + "ms");
        retryScheduler.schedule(() -> {
            try {
                if (this.isGuildReady(guildId)) {
                    DiSky.debug("Guild " + guildId + " became ready during retry attempt " + currentAttempt);
                    this.processGuildReady(guildId);
                } else {
                    DiSky.debug("Guild " + guildId + " still not ready on retry attempt " + currentAttempt);
                    this.scheduleGuildRegistrationRetry(guildId);
                }
            }
            catch (Exception e) {
                DiSky.debug("Error during retry attempt for guild " + guildId + ": " + e.getMessage());
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void tryExecute(RegisteredGroup group, ParsedCommand command, SlashCommandInteractionEvent event) {
        SkriptUtils.sync(() -> {
            if (this.handleCooldown(group, command, event)) {
                return;
            }
            this.executeCommand(command, event);
        });
    }

    private boolean handleCooldown(RegisteredGroup group, ParsedCommand command, SlashCommandInteractionEvent event) {
        if (command.hasCooldown()) {
            String commandPath = command.getOriginalName();
            if (group.isInCooldown(event.getUser(), commandPath)) {
                if (command.getOnCooldown() != null) {
                    SlashCooldownEvent jdaEvent = new SlashCooldownEvent(event, group.getCooldown(event.getUser(), commandPath));
                    Event bukkitEvent = CommandEvents.SLASH_COOLDOWN_EVENT.createBukkitInstance(jdaEvent);
                    command.prepareArguments(event);
                    command.getOnCooldown().execute(bukkitEvent);
                    return !jdaEvent.isCancelled();
                }
                return true;
            }
            group.setCooldown(event.getUser(), commandPath, command.getCooldown());
        }
        return false;
    }

    private void executeCommand(ParsedCommand command, SlashCommandInteractionEvent event) {
        command.prepareArguments(event);
        Trigger trigger = command.getTrigger();
        Event bukkitEvent = CommandEvents.SLASH_COMMAND_EVENT.createBukkitInstance(event);
        trigger.execute(bukkitEvent);
    }

    private void handleAutoComplete(ParsedCommand command, CommandAutoCompleteInteractionEvent event) {
        String focusedArgument = event.getFocusedOption().getName();
        ParsedArgument focusArg = command.getArguments().stream().filter(arg -> arg.getName().equals(focusedArgument)).findFirst().orElse(null);
        if (focusArg == null) {
            DiSky.debug("No completion trigger for argument " + focusedArgument);
            return;
        }
        if (focusArg.getCustomArgument() == null) {
            command.prepareArguments(event);
            Event bukkitEvent = CommandEvents.SLASH_COMPLETION_EVENT.createBukkitInstance(event);
            Trigger trigger = focusArg.getOnCompletionRequest();
            if (trigger == null) {
                DiSky.debug("No completion trigger for argument " + focusedArgument);
                return;
            }
            trigger.execute(bukkitEvent);
        } else {
            String input;
            CustomArgument<?> customArgument = focusArg.getCustomArgument();
            List<Command.Choice> choices = customArgument.handleAutoCompletion(event, input = event.getFocusedOption().getValue());
            if (choices != null) {
                event.replyChoices(choices).queue();
            } else {
                DiSky.debug("No choices for argument " + focusedArgument);
            }
        }
    }

    public void shutdown() {
        this.bot.getInstance().removeEventListener(this);
        this.cleanupRegisteredGroups();
        this.registeredGroups.clear();
        this.commandGroups.clear();
        this.guildRetryAttempts.clear();
    }

    private void cleanupRegisteredGroups() {
        HashSet guilds = new HashSet();
        this.registeredGroups.forEach(group -> {
            if (group.getGuildId() != null) {
                guilds.add(group.getGuildId());
            }
        });
        for (String guildId : guilds) {
            Guild guild = this.bot.getInstance().getGuildById(guildId);
            if (guild == null) {
                DiSky.debug("Guild " + guildId + " not found, skipping command deletion");
                continue;
            }
            try {
                CompletableFuture futureCommands = new CompletableFuture();
                guild.retrieveCommands().queue(futureCommands::complete, futureCommands::completeExceptionally);
                List commands = (List)futureCommands.get(3L, TimeUnit.SECONDS);
                Iterator iterator2 = commands.iterator();
                while (iterator2.hasNext()) {
                    Command cmd = (Command)iterator2.next();
                    CompletableFuture future = new CompletableFuture();
                    guild.deleteCommandById(cmd.getId()).queue(v -> future.complete(null), future::completeExceptionally);
                    future.get(3L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                DiSky.debug("Failed to delete guild commands: " + e.getMessage());
                for (StackTraceElement trace : e.getStackTrace()) {
                    DiSky.debug("  " + String.valueOf(trace));
                }
            }
        }
        try {
            CompletableFuture futureCommands = new CompletableFuture();
            this.bot.getInstance().retrieveCommands().queue(futureCommands::complete, futureCommands::completeExceptionally);
            List commands = (List)futureCommands.get(3L, TimeUnit.SECONDS);
            for (Command cmd : commands) {
                CompletableFuture future = new CompletableFuture();
                this.bot.getInstance().deleteCommandById(cmd.getId()).queue(v -> future.complete(null), future::completeExceptionally);
                future.get(3L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            DiSky.debug("Failed to delete global commands: " + e.getMessage());
            for (StackTraceElement trace : e.getStackTrace()) {
                DiSky.debug("  " + String.valueOf(trace));
            }
        }
    }

    public void deleteLocalGroup(RegisteredGroup group) {
        this.registeredGroups.remove(group);
        Guild guild = this.bot.getInstance().getGuildById(group.getGuildId());
        if (guild == null) {
            DiSky.debug("Guild " + group.getGuildId() + " is not available, skipping command deletion");
            return;
        }
        guild.deleteCommandById(group.getCommandId()).complete();
    }

    public void deleteGlobalGroup(RegisteredGroup group) {
        this.registeredGroups.remove(group);
        this.bot.getInstance().deleteCommandById(group.getCommandId()).complete();
    }

    public String getCommandDebugInfo() {
        StringBuilder debug = new StringBuilder();
        debug.append("Command Groups (").append(this.commandGroups.size()).append("):\n");
        for (CommandGroup group2 : this.commandGroups.values()) {
            ParsedCommand cmd2;
            debug.append("\nGroup: ").append(group2.getName()).append(" (Type: ").append((Object)group2.getType()).append(")\n");
            if (group2.getType() == CommandType.SINGLE && (cmd2 = group2.getSingleCommand()) != null) {
                debug.append("  Single Command: ").append(cmd2.getName()).append(" (").append(cmd2.getDescription()).append(")\n");
            }
            if (!group2.getSubCommands().isEmpty()) {
                debug.append("  Subcommands:\n");
                group2.getSubCommands().forEach((name, cmd) -> debug.append("    - ").append((String)name).append(" (").append(cmd.getDescription()).append(")\n"));
            }
            if (group2.getSubGroups().isEmpty()) continue;
            debug.append("  Subgroups:\n");
            group2.getSubGroups().forEach((name, subgroup) -> {
                debug.append("    + ").append((String)name).append(":\n");
                subgroup.getSubCommands().forEach((subname, cmd) -> debug.append("      - ").append((String)subname).append(" (").append(cmd.getDescription()).append(")\n"));
            });
        }
        debug.append("\nRegistered Groups (").append(this.registeredGroups.size()).append("):\n");
        this.registeredGroups.forEach(group -> debug.append("  - ").append(group.getCommandGroup().getName()).append(" (ID: ").append(group.getCommandId()).append(")").append((String)(group.getGuildId() != null ? " [Guild: " + group.getGuildId() + "]" : " [Global]")).append("\n"));
        return debug.toString();
    }

    public Map<String, CommandGroup> getCommandGroups() {
        return Collections.unmodifiableMap(this.commandGroups);
    }

    public List<RegisteredGroup> getRegisteredGroups() {
        return Collections.unmodifiableList(this.registeredGroups);
    }
}

