/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.util.Timespan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.api.skript.entries.MutexEntryData;
import net.itsthesky.disky.api.skript.entries.SimpleKeyValueEntries;
import net.itsthesky.disky.core.Bot;
import net.itsthesky.disky.core.SkriptUtils;
import net.itsthesky.disky.elements.events.rework.CommandEvents;
import net.itsthesky.disky.elements.structures.slash.BotReadyWaiter;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import net.itsthesky.disky.elements.structures.slash.args.SlashCustomArgs;
import net.itsthesky.disky.elements.structures.slash.models.ParsedArgument;
import net.itsthesky.disky.elements.structures.slash.models.ParsedCommand;
import net.itsthesky.disky.elements.structures.slash.models.SlashCommandInformation;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.KeyValueEntryData;
import org.skriptlang.skript.lang.structure.Structure;

public class StructSlashCommand
extends Structure {
    public static final Structure.Priority PRIORITY = new Structure.Priority(800);
    public static final Set<SlashCommandInformation> REMOVED_COMMANDS = new HashSet<SlashCommandInformation>();
    private static final Pattern ARGUMENT = Pattern.compile("(\\[)?<(?<type>\\w+)=\"(?<name>\\w+)\">(\\])?");
    private static final Pattern STRUCTURE = Pattern.compile("slash command (([A-Za-z0-9_\\-]+ )?([A-Za-z0-9_\\-]+ )?([A-Za-z0-9_\\-]+)?)([^<]*<.+)?");
    private static final Pattern LIST = Pattern.compile("\\s*,\\s*/?");
    private static final EntryValidator CORE_VALIDATOR = EntryValidator.builder().addEntryData(new MutexEntryData<String>("description", "def", false, SkriptUtils.custom(), String::valueOf)).addEntryData(SimpleKeyValueEntries.createList("enabled for", new ArrayList(), true, value -> Permission.valueOf(value.toUpperCase().replace(" ", "_")))).addEntryData(SimpleKeyValueEntries.createBooleanEntry("disabled", false, true)).addEntry("bot", "", true).addEntry("guilds", "", true).addSection("arguments", true).addSection("name", true).addEntry("group", "", true).addEntryData((EntryData)new KeyValueEntryData<Timespan>("cooldown", null, true){

        @Nullable
        protected Timespan getValue(@NotNull String value) {
            return Timespan.parse((String)value);
        }
    }).addSection("on cooldown", true).addSection("trigger", false).build();
    private static final EntryValidator ARGUMENT_VALIDATOR = EntryValidator.builder().addEntry("description", "", false).addSection("choices", true).addSection("on completion request", true).build();
    private ParsedCommand parsedCommand;
    private EntryContainer entryContainer;
    @NotNull
    private Node structure;
    private Node node;

    public ParsedCommand getParsedCommand() {
        return this.parsedCommand;
    }

    public boolean init(Literal<?> @NotNull [] args, int matchedPattern, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull EntryContainer entryContainer) {
        this.entryContainer = entryContainer;
        this.structure = entryContainer.getSource();
        this.node = this.getParser().getNode();
        return true;
    }

    public boolean load() {
        this.parsedCommand = new ParsedCommand();
        String commandName = this.parseCommandName();
        if (commandName == null) {
            return false;
        }
        this.parsedCommand.setName(commandName);
        List<ParsedArgument> arguments = this.parseArguments();
        if (arguments == null) {
            return false;
        }
        this.parsedCommand.setArguments(arguments);
        boolean description = this.parseDescription();
        if (!description) {
            return false;
        }
        boolean name = this.parseName();
        if (!name) {
            return false;
        }
        this.parsedCommand.setEnabledFor((List)this.entryContainer.get("enabled for", List.class, true));
        this.parsedCommand.setDisabledByDefault((Boolean)this.entryContainer.get("disabled", Boolean.class, true));
        boolean validPlaces = this.parsePlaces();
        if (!validPlaces) {
            return false;
        }
        boolean trigger = this.parseTrigger();
        if (!trigger) {
            return false;
        }
        boolean cooldown = this.parseCooldown();
        if (!cooldown) {
            return false;
        }
        DiSky.debug("------------------- Name -------------------");
        DiSky.debug("Default: " + this.parsedCommand.getName());
        for (DiscordLocale locale : this.parsedCommand.getNameLocalizations().keySet()) {
            DiSky.debug(" - Locale: " + String.valueOf((Object)locale) + " | Value: " + this.parsedCommand.getNameLocalizations().get((Object)locale));
        }
        if (this.parsedCommand.getNameLocalizations().isEmpty()) {
            DiSky.debug("No localizations found.");
        }
        DiSky.debug("------------------- Args (" + this.parsedCommand.getArguments().size() + ") -------------------");
        for (ParsedArgument arg : this.parsedCommand.getArguments()) {
            DiSky.debug("Argument: " + arg.getName() + " | Type: " + String.valueOf((Object)arg.getType()) + " | Optional: " + arg.isOptional());
            DiSky.debug("Custom Argument: " + String.valueOf(arg.getCustomArgument()));
            if (arg.hasChoices()) {
                DiSky.debug(" - Choices (" + arg.getChoices().size() + "):");
                for (String choice : arg.getChoices().keySet()) {
                    DiSky.debug("   - " + choice + " | Value: " + String.valueOf(arg.getChoices().get(choice)));
                }
            }
            DiSky.debug(" - Description: " + arg.getDescription());
        }
        DiSky.debug("------------------- Description -------------------");
        DiSky.debug("Default: " + this.parsedCommand.getDescription());
        for (DiscordLocale locale : this.parsedCommand.getDescriptionLocalizations().keySet()) {
            DiSky.debug(" - Locale: " + String.valueOf((Object)locale) + " | Value: " + this.parsedCommand.getDescriptionLocalizations().get((Object)locale));
        }
        if (this.parsedCommand.getDescriptionLocalizations().isEmpty()) {
            DiSky.debug("No localizations found.");
        }
        DiSky.debug("------------------- Meta -------------------");
        DiSky.debug("Enabled for: " + String.valueOf(this.parsedCommand.getEnabledFor()));
        DiSky.debug("Disabled by default: " + this.parsedCommand.isDisabledByDefault());
        DiSky.debug("------------------- Places -------------------");
        DiSky.debug("Pre-bot (name): " + this.parsedCommand.getRawBot());
        for (String guild : this.parsedCommand.getGuilds()) {
            DiSky.debug("- Guild: " + guild);
        }
        DiSky.debug("------------------- Trigger -------------------");
        if (this.parsedCommand.getTrigger() != null) {
            DiSky.debug("Trigger found.");
            DiSky.debug(" - Label: " + this.parsedCommand.getTrigger().getDebugLabel());
        } else {
            DiSky.debug("No trigger found.");
        }
        DiSky.debug("------------------- Cooldown -------------------");
        if (this.parsedCommand.hasCooldown()) {
            DiSky.debug("Cooldown: " + this.parsedCommand.getCooldown() + "ms (" + this.parsedCommand.getCooldown() / 1000L + "s)");
            if (this.parsedCommand.getOnCooldown() != null) {
                DiSky.debug(" - On Cooldown trigger found.");
                DiSky.debug("   - Label: " + this.parsedCommand.getOnCooldown().getDebugLabel());
            } else {
                DiSky.debug(" - No on cooldown trigger found.");
            }
        } else {
            DiSky.debug("No cooldown found.");
        }
        DiSky.debug("------------------- End -------------------");
        Bot bot = DiSky.getManager().getBotByName(this.parsedCommand.getRawBot());
        if (bot == null || bot.getInstance().getStatus() != JDA.Status.CONNECTED) {
            BotReadyWaiter.WaitingCommands.computeIfAbsent(this.parsedCommand.getRawBot(), k -> new ArrayList()).add(this.parsedCommand);
        } else {
            bot.getSlashManager().registerCommand(this.parsedCommand);
        }
        REMOVED_COMMANDS.removeIf(info -> info.getCommand().equals(this.parsedCommand.getName()));
        return true;
    }

    public void unload() {
        REMOVED_COMMANDS.add(new SlashCommandInformation(this.parsedCommand, this.node));
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "Slash Command Structure";
    }

    private List<ParsedArgument> parseArguments() {
        OptionType type;
        String[] args;
        ArrayList<ParsedArgument> arguments = new ArrayList<ParsedArgument>();
        String rawStructure = this.entryContainer.getSource().getKey();
        Matcher argsMatcher = STRUCTURE.matcher(rawStructure.split("#")[0]);
        if (!argsMatcher.matches()) {
            Skript.error((String)("Invalid structure pattern: " + this.entryContainer.getSource().getKey()));
            return null;
        }
        String rawArguments = argsMatcher.group(5);
        if (rawArguments == null || rawArguments.trim().isEmpty()) {
            return arguments;
        }
        for (String arg : args = rawArguments.trim().split("\\s+(?=(?:\\[)?<)")) {
            if ((arg = arg.trim()).isEmpty()) continue;
            Matcher matcher = ARGUMENT.matcher(arg);
            if (!matcher.matches()) {
                Skript.error((String)("Invalid argument pattern: " + arg));
                return null;
            }
            String rawType = matcher.group("type");
            String name = matcher.group("name");
            boolean optional = arg.startsWith("[") && arg.endsWith("]");
            try {
                type = OptionType.valueOf(rawType.toUpperCase());
            }
            catch (Exception ex) {
                CustomArgument<?> customArg = SlashCustomArgs.tryParseCustomArgument(rawType);
                if (customArg == null) {
                    Skript.error((String)("Invalid argument type: " + rawType + " (Available: " + Stream.of(OptionType.values()).map(Enum::name).reduce((a, b) -> a + ", " + b).orElse("None") + ")"));
                    return null;
                }
                ParsedArgument parsedArgument = new ParsedArgument(customArg.getType(), name, !optional);
                parsedArgument.setCustomArgument(customArg);
                arguments.add(parsedArgument);
                continue;
            }
            arguments.add(new ParsedArgument(type, name, !optional));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ParsedArgument arg = (ParsedArgument)arguments.get(i);
            for (int j = i + 1; j < arguments.size(); ++j) {
                ParsedArgument other = (ParsedArgument)arguments.get(j);
                if (!arg.getName().equalsIgnoreCase(other.getName())) continue;
                Skript.error((String)("Duplicated argument name: " + arg.getName()));
                return null;
            }
        }
        SectionNode node = (SectionNode)this.entryContainer.getOptional("arguments", SectionNode.class, true);
        if (node == null) {
            Skript.error((String)"No arguments section found. Refer to the wiki for more information.");
            return null;
        }
        node.convertToEntries(0);
        for (ParsedArgument argument : arguments) {
            Node argNode = node.get(argument.getName());
            if (argNode == null) continue;
            if (argNode instanceof SectionNode) {
                SectionNode completionNode;
                SectionNode argSection = (SectionNode)argNode;
                EntryContainer container2 = ARGUMENT_VALIDATOR.validate(argSection);
                if (container2 == null) {
                    return null;
                }
                String description = (String)container2.get("description", String.class, true);
                SectionNode choiceNode = (SectionNode)container2.getOptional("choices", SectionNode.class, true);
                if (choiceNode != null) {
                    type = argument.getType();
                    if (!type.canSupportChoices()) {
                        Skript.error((String)("Choices are not supported for the argument type: " + String.valueOf((Object)type)));
                        return null;
                    }
                    choiceNode.convertToEntries(0);
                    for (Node choice : choiceNode) {
                        Object parsedValue;
                        String choiceName;
                        block23: {
                            choiceName = choice.getKey();
                            String value = choiceNode.get(choiceName, "");
                            if (value.isEmpty()) {
                                Skript.error((String)("Empty value for choice: " + choiceName));
                                return null;
                            }
                            try {
                                if (type.equals((Object)OptionType.NUMBER) || type.equals((Object)OptionType.INTEGER)) {
                                    parsedValue = Integer.parseInt(value);
                                    break block23;
                                }
                                if (type.equals((Object)OptionType.STRING)) {
                                    parsedValue = value;
                                    break block23;
                                }
                                Skript.error((String)("Invalid choice type: " + String.valueOf((Object)type)));
                                return null;
                            }
                            catch (NumberFormatException ex) {
                                Skript.error((String)("Invalid number value for choice: " + choiceName));
                                return null;
                            }
                        }
                        argument.addChoice(choiceName, parsedValue);
                    }
                }
                if ((completionNode = (SectionNode)container2.getOptional("on completion request", SectionNode.class, true)) != null) {
                    if (argument.hasChoices()) {
                        Skript.error((String)"You can't have both auto completion and choices for the same argument.");
                        return null;
                    }
                    Trigger trigger = new Trigger(this.getParser().getCurrentScript(), "completion for argument " + argument.getName(), (SkriptEvent)new SimpleEvent(), SkriptUtils.loadCode(completionNode, CommandEvents.SLASH_COMPLETION_EVENT.getBukkitEventClass()));
                    argument.setOnCompletionRequest(trigger);
                }
                argument.setDescription(description);
                continue;
            }
            String description = node.getValue(argument.getName());
            argument.setDescription(description);
        }
        return arguments;
    }

    private void parseChoices(ParsedArgument argument, EntryContainer container2) {
        SectionNode choiceNode = (SectionNode)container2.getOptional("choices", SectionNode.class, true);
        if (choiceNode != null) {
            OptionType type = argument.getType();
            if (!type.canSupportChoices()) {
                Skript.error((String)("Choices are not supported for the argument type: " + String.valueOf((Object)type)));
                return;
            }
            choiceNode.convertToEntries(0);
            for (Node choice : choiceNode) {
                String name = choice.getKey();
                String value = choiceNode.get(name, "");
                if (value.isEmpty()) {
                    Skript.error((String)("Empty value for choice: " + name));
                    return;
                }
                this.parseAndAddChoice(argument, type, name, value);
            }
        }
    }

    private void parseAndAddChoice(ParsedArgument argument, OptionType type, String name, String value) {
        try {
            Object parsedValue;
            switch (type) {
                case INTEGER: {
                    parsedValue = Integer.parseInt(value);
                    break;
                }
                case NUMBER: {
                    parsedValue = Double.parseDouble(value);
                    break;
                }
                case STRING: {
                    parsedValue = value;
                    break;
                }
                default: {
                    Skript.error((String)("Unsupported choice type: " + String.valueOf((Object)type)));
                    return;
                }
            }
            argument.addChoice(name, parsedValue);
        }
        catch (NumberFormatException ex) {
            Skript.error((String)("Invalid number value for choice: " + name));
        }
    }

    private void parseAutoCompletion(ParsedArgument argument, EntryContainer container2) {
        SectionNode completionNode = (SectionNode)container2.getOptional("on completion request", SectionNode.class, true);
        if (completionNode != null) {
            if (argument.hasChoices()) {
                Skript.error((String)"You can't have both auto completion and choices for the same argument.");
                return;
            }
            Trigger trigger = new Trigger(this.getParser().getCurrentScript(), "completion for argument " + argument.getName(), (SkriptEvent)new SimpleEvent(), SkriptUtils.loadCode(completionNode, CommandEvents.SLASH_COMPLETION_EVENT.getBukkitEventClass()));
            argument.setOnCompletionRequest(trigger);
        }
    }

    public String parseCommandName() {
        String rawStructure = this.entryContainer.getSource().getKey();
        Matcher matcher = STRUCTURE.matcher(rawStructure.split("#")[0]);
        if (!matcher.matches()) {
            Skript.error((String)("Invalid structure pattern: " + this.entryContainer.getSource().getKey()));
            return null;
        }
        String commandName = matcher.group(1).trim();
        String[] parts = commandName.split("\\s+");
        if (parts.length > 3) {
            Skript.error((String)("Command can only have up to 3 levels (command, group, and subcommand). Got: " + commandName));
            return null;
        }
        for (String part : parts) {
            if (part.matches("[_'\\p{L}\\p{N}\\p{sc=Deva}\\p{sc=Thai}]{1,32}")) continue;
            Skript.error((String)("Invalid command name part: '" + part + "'. Must match Discord's naming requirements."));
            return null;
        }
        return commandName;
    }

    public static Map<DiscordLocale, String> parseLocalizations(SectionNode section2) {
        section2.convertToEntries(0);
        HashMap<DiscordLocale, String> localizations = new HashMap<DiscordLocale, String>();
        for (Node node : section2) {
            String key = node.getKey();
            String value = section2.get(key, "");
            if (value.isEmpty()) {
                Skript.error((String)("Empty localization value for key: " + key));
                return null;
            }
            DiscordLocale locale = DiscordLocale.from(key.equals("en") ? "en-US" : key);
            if (locale == DiscordLocale.UNKNOWN) {
                Skript.error((String)("Invalid locale key: " + key + " (Available: " + Arrays.toString((Object[])DiscordLocale.values()) + ")"));
                return null;
            }
            localizations.put(locale, value);
        }
        return localizations;
    }

    public boolean parseDescription() {
        MutexEntryData.MutexEntry description = (MutexEntryData.MutexEntry)this.entryContainer.get("description", MutexEntryData.MutexEntry.class, true);
        if (description.isComplex()) {
            EntryContainer subs = description.getEntryContainer();
            if (subs == null) {
                return false;
            }
            Map<DiscordLocale, String> localizations = StructSlashCommand.parseLocalizations(subs.getSource());
            if (localizations == null) {
                return false;
            }
            String defaultDescription = localizations.get((Object)DiscordLocale.ENGLISH_US);
            if (defaultDescription == null) {
                Skript.error((String)"You must specify a default description for the command. (en-US)");
                return false;
            }
            this.parsedCommand.setDescriptionLocalizations(localizations);
            this.parsedCommand.setDescription(defaultDescription);
        } else {
            this.parsedCommand.setDescription((String)description.getValue());
        }
        return true;
    }

    public boolean parseName() {
        SectionNode sectionNode = (SectionNode)this.entryContainer.getOptional("name", SectionNode.class, true);
        if (sectionNode == null) {
            return true;
        }
        Map<DiscordLocale, String> localizations = StructSlashCommand.parseLocalizations(sectionNode);
        if (localizations == null) {
            return false;
        }
        this.parsedCommand.setNameLocalizations(localizations);
        return true;
    }

    public boolean parsePlaces() {
        String rawBot = (String)this.entryContainer.getOptional("bot", String.class, true);
        String rawGuilds = (String)this.entryContainer.getOptional("guilds", String.class, true);
        if ((rawBot == null || rawBot.isEmpty()) && (rawGuilds == null || rawGuilds.isEmpty())) {
            this.getParser().setNode(this.structure);
            Skript.error((String)"You must specify at least one bot or guild ID.");
            return false;
        }
        if (rawBot == null || rawBot.isEmpty()) {
            this.getParser().setNode(this.structure);
            Skript.error((String)"You must specify at least one bot.");
            return false;
        }
        this.parsedCommand.setRawBot(rawBot);
        if (!rawGuilds.isEmpty()) {
            String[] guildIds;
            for (String guildId : guildIds = rawGuilds.split(LIST.pattern())) {
                if (!guildId.matches("\\d+")) {
                    this.getParser().setNode(this.structure);
                    Skript.error((String)("Invalid guild ID: " + guildId));
                    return false;
                }
                this.parsedCommand.addGuild(guildId);
            }
        }
        return true;
    }

    public boolean parseTrigger() {
        SectionNode sectionNode = (SectionNode)this.entryContainer.getOptional("trigger", SectionNode.class, true);
        if (sectionNode == null) {
            return true;
        }
        Trigger trigger = new Trigger(this.getParser().getCurrentScript(), "on slash command " + this.parsedCommand.getName(), CommandEvents.SLASH_COMMAND_EVENT.createDiSkyEvent(), SkriptUtils.loadCode(sectionNode, CommandEvents.SLASH_COMMAND_EVENT.getBukkitEventClass()));
        this.parsedCommand.setTrigger(trigger);
        return true;
    }

    public boolean parseCooldown() {
        Timespan cooldown = (Timespan)this.entryContainer.getOptional("cooldown", Timespan.class, true);
        if (cooldown == null) {
            return true;
        }
        SectionNode sectionNode = (SectionNode)this.entryContainer.getOptional("on cooldown", SectionNode.class, true);
        if (sectionNode == null) {
            Skript.error((String)"You must specify a section for the cooldown. ('on cooldown' section, to be ran when the command is on cooldown)");
            return false;
        }
        Trigger trigger = new Trigger(this.getParser().getCurrentScript(), "on cooldown for " + this.parsedCommand.getName(), CommandEvents.SLASH_COOLDOWN_EVENT.createDiSkyEvent(), SkriptUtils.loadCode(sectionNode, CommandEvents.SLASH_COOLDOWN_EVENT.getBukkitEventClass()));
        this.parsedCommand.setCooldown(cooldown.getAs(Timespan.TimePeriod.MILLISECOND));
        this.parsedCommand.setOnCooldown(trigger);
        return true;
    }

    @NotNull
    public Structure.Priority getPriority() {
        return PRIORITY;
    }

    static {
        Skript.registerStructure(StructSlashCommand.class, (EntryValidator)CORE_VALIDATOR, (String[])new String[]{"slash command <([^\\s]+)( .+)?$>"});
    }
}

