/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.args;

import ch.njol.skript.classes.ClassInfo;
import java.util.List;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomArgument<T> {
    protected final Class<T> clazz;
    protected final OptionType type;
    protected final boolean autoCompletion;
    protected final boolean choices;

    protected CustomArgument(Class<T> clazz, OptionType type, boolean autoCompletion, boolean choices) {
        this.clazz = clazz;
        this.type = type;
        this.autoCompletion = autoCompletion;
        this.choices = choices;
        if (!type.canSupportChoices() && choices) {
            throw new IllegalArgumentException("The type " + String.valueOf((Object)type) + " does not support choices.");
        }
    }

    public boolean supportsClass(@NotNull ClassInfo<?> classInfo) {
        if (classInfo.getC() == null) {
            return false;
        }
        return this.clazz.isAssignableFrom(classInfo.getC());
    }

    @Nullable
    public abstract T convert(@NotNull SlashCommandInteractionEvent var1, @NotNull OptionMapping var2);

    @Nullable
    public abstract T convert(@NotNull CommandAutoCompleteInteractionEvent var1, @NotNull OptionMapping var2);

    public List<Command.Choice> handleAutoCompletion(@NotNull CommandAutoCompleteInteractionEvent event, @NotNull String input) {
        return null;
    }

    public List<Command.Choice> getChoices() {
        return null;
    }

    public OptionType getType() {
        return this.type;
    }

    public boolean isAutoCompletion() {
        return this.autoCompletion;
    }

    public boolean isChoices() {
        return this.choices;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String toString() {
        return "CustomArgument{clazz=" + String.valueOf(this.clazz) + ", type=" + String.valueOf((Object)this.type) + ", autoCompletion=" + this.autoCompletion + ", choices=" + this.choices + "}";
    }
}

