/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.args;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import java.util.HashSet;
import java.util.Set;
import net.itsthesky.disky.DiSky;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import net.itsthesky.disky.elements.structures.slash.args.custom.ColorCustomArg;
import net.itsthesky.disky.elements.structures.slash.args.custom.EnumCustomArg;
import net.itsthesky.disky.elements.structures.slash.args.custom.MemberCustomArg;
import net.itsthesky.disky.elements.structures.slash.args.custom.PlayerCustomArg;
import net.itsthesky.disky.elements.structures.slash.args.custom.SmallEnumCustomArg;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class SlashCustomArgs {
    private static final Set<CustomArgument<?>> AVAILABLE_ARGUMENTS = new HashSet();

    private static void waitForClasses() {
        while (Skript.isAcceptRegistrations()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        SlashCustomArgs.registerEnums();
    }

    private static int registerEnums() {
        int count = 0;
        for (ClassInfo clazz : Classes.getClassInfos()) {
            Class enumClass;
            if (clazz.getC() == null || !Enum.class.isAssignableFrom(clazz.getC()) || (enumClass = clazz.getC()).getEnumConstants() == null || ((Enum[])enumClass.getEnumConstants()).length == 0) continue;
            if (((Enum[])enumClass.getEnumConstants()).length <= 25) {
                SlashCustomArgs.register(new SmallEnumCustomArg(enumClass));
            } else {
                SlashCustomArgs.register(new EnumCustomArg(enumClass));
            }
            ++count;
        }
        return count;
    }

    public static void register(CustomArgument<?> argument) {
        AVAILABLE_ARGUMENTS.add(argument);
    }

    public static Set<CustomArgument<?>> getAvailableArguments() {
        return Set.copyOf(AVAILABLE_ARGUMENTS);
    }

    @Nullable
    public static CustomArgument<?> tryParseCustomArgument(String input) {
        ClassInfo classInfo = Classes.getClassInfo((String)input);
        if (classInfo == null) {
            return null;
        }
        for (CustomArgument<?> argument : AVAILABLE_ARGUMENTS) {
            if (!argument.supportsClass(classInfo)) continue;
            return argument;
        }
        return null;
    }

    static {
        AVAILABLE_ARGUMENTS.add(new MemberCustomArg());
        AVAILABLE_ARGUMENTS.add(new ColorCustomArg());
        AVAILABLE_ARGUMENTS.add(new PlayerCustomArg(true));
        AVAILABLE_ARGUMENTS.add(new PlayerCustomArg(false));
        int normalArgs = AVAILABLE_ARGUMENTS.size();
        Thread thread = new Thread(() -> {
            SlashCustomArgs.waitForClasses();
            Bukkit.getScheduler().runTask((Plugin)DiSky.getInstance(), () -> {
                int count = SlashCustomArgs.registerEnums();
                DiSky.getInstance().getLogger().info("Registered " + AVAILABLE_ARGUMENTS.size() + " custom arguments (including " + count + " enums and " + normalArgs + " custom ones)");
            });
        });
        thread.setName("DiSky - Slash Custom Args Registration");
        thread.setDaemon(true);
        thread.start();
    }
}

