/*
 * Decompiled with CFR 0.152.
 */
package net.itsthesky.disky.elements.structures.slash.args.custom;

import ch.njol.skript.classes.ClassInfo;
import java.util.List;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.itsthesky.disky.elements.structures.slash.args.CustomArgument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallEnumCustomArg
extends CustomArgument<Enum> {
    public SmallEnumCustomArg(Class<Enum> clazz) {
        super(clazz, OptionType.STRING, false, true);
    }

    @Override
    public List<Command.Choice> getChoices() {
        Enum[] enumConstants = (Enum[])this.clazz.getEnumConstants();
        return List.of(enumConstants).stream().map(enumConstant -> new Command.Choice(SmallEnumCustomArg.beautifyEnumName(enumConstant.name()), enumConstant.name())).toList();
    }

    @Override
    @Nullable
    public Enum convert(@NotNull SlashCommandInteractionEvent event, @NotNull OptionMapping mapping) {
        String enumName = mapping.getAsString();
        return Enum.valueOf(this.clazz, enumName);
    }

    @Override
    @Nullable
    public Enum convert(@NotNull CommandAutoCompleteInteractionEvent event, @NotNull OptionMapping mapping) {
        String enumName = mapping.getAsString();
        return Enum.valueOf(this.clazz, enumName);
    }

    public static String beautifyEnumName(String name) {
        String lower = name.replaceAll("_", " ").toLowerCase();
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    @Override
    public boolean supportsClass(@NotNull ClassInfo<?> classInfo) {
        return classInfo.getC().isEnum() && classInfo.getC().isAssignableFrom(this.clazz);
    }
}

